/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.OriComp;
import SRM.Orientation;
import SRM.SRM_Matrix_3x3;
import SRM.SRM_Ori_Rep;
import SRM.SRM_Tait_Bryan_Angles_Params;
import SRM.SrmException;

public class OrientationTaitBryanAngles
extends Orientation {
    private SRM_Tait_Bryan_Angles_Params _tait_bryan_angles = new SRM_Tait_Bryan_Angles_Params();

    public OrientationTaitBryanAngles() {
    }

    public OrientationTaitBryanAngles(SRM_Tait_Bryan_Angles_Params params) throws SrmException {
        if (!params.valid()) {
            throw new SrmException(8, "OrientationTaitBryanAngles(roll, pitch, yaw): invalid parameters");
        }
        this._tait_bryan_angles.roll = params.roll;
        this._tait_bryan_angles.pitch = params.pitch;
        this._tait_bryan_angles.yaw = params.yaw;
    }

    public OrientationTaitBryanAngles(double roll, double pitch, double yaw) throws SrmException {
        SRM_Tait_Bryan_Angles_Params ea = new SRM_Tait_Bryan_Angles_Params(roll, pitch, yaw);
        if (!ea.valid()) {
            throw new SrmException(8, "OrientationTaitBryanAngles(roll, pitch, yaw): invalid parameters");
        }
        this._tait_bryan_angles = ea;
    }

    public SRM_Tait_Bryan_Angles_Params getTaitBryanAngles() {
        return new SRM_Tait_Bryan_Angles_Params(this._tait_bryan_angles);
    }

    public void setTaitBryanAngles(SRM_Tait_Bryan_Angles_Params params) throws SrmException {
        if (!params.valid()) {
            throw new SrmException(8, "OrientationTaitBryanAngles.setTaitBryanAngles: invalid parameters");
        }
        this._tait_bryan_angles.roll = params.roll;
        this._tait_bryan_angles.pitch = params.pitch;
        this._tait_bryan_angles.yaw = params.yaw;
        this._set_internal_data_is_current(false);
    }

    public String toString() {
        return this._tait_bryan_angles.toString();
    }

    public SRM_Ori_Rep getOriRep() {
        return SRM_Ori_Rep.ORI_REP_TAIT_BRYAN_ANGLES;
    }

    public static OrientationTaitBryanAngles compose(Orientation left, Orientation right) throws SrmException {
        SRM_Matrix_3x3 ret_mat = OriComp.matrixMultiply(left.getMatrix3x3(), right.getMatrix3x3());
        return new OrientationTaitBryanAngles(OriComp.matrix_to_tait_bryan(ret_mat));
    }

    protected void _updateIntData() {
        if (!this._get_internal_data_is_current()) {
            this._set_matrix_base(OriComp.tait_bryan_to_matrix(this._tait_bryan_angles));
            this._set_internal_data_is_current(true);
        }
    }

    protected void _updateRepData() {
        this._tait_bryan_angles = OriComp.matrix_to_tait_bryan(this._get_matrix_base_unch());
        this._set_internal_data_is_current(true);
    }
}

