/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.OrmDataSet;
import SRM.RdDataSet;
import SRM.SRM_ORMT_Code;
import SRM.SRM_ORM_Code;
import SRM.SRM_RD_Code;

public class OrmData {
    public double A;
    public double A_inv;
    public double B;
    public double B_inv;
    public double F;
    public double F_inv;
    public double C;
    public double Eps2;
    public double Eps;
    public double Epps2;
    public double EpsH;
    public double Eps25;
    public double A2;
    public double A2_inv;
    public double C2;

    public OrmData(SRM_ORM_Code orm) {
        SRM_RD_Code rdCode = OrmDataSet.getElem((SRM_ORM_Code)orm)._rd_code;
        SRM_ORMT_Code tmpORMT = OrmDataSet.getElem((SRM_ORM_Code)orm)._orm_template;
        if (orm.toInt() >= 0) {
            if (rdCode != SRM_RD_Code.RDCOD_UNSPECIFIED) {
                RdDataSet rdSet = RdDataSet.getElem(rdCode);
                switch (tmpORMT) {
                    case ORMTCOD_SPHERE: 
                    case ORMTCOD_SPHERE_ORIGIN: {
                        this.A = rdSet._R;
                        this.F_inv = Double.NaN;
                        this.F = 0.0;
                        this.A_inv = 1.0 / this.A;
                        this.A2 = this.A * this.A;
                        this.A2_inv = 1.0 / this.A2;
                        this.B = this.A * (1.0 - this.F);
                        this.B_inv = this.A_inv;
                        this.C = this.A * (1.0 - this.F);
                        this.Eps2 = 0.0;
                        this.Eps = Math.sqrt(this.Eps2);
                        this.Eps25 = 0.25 * this.Eps2;
                        this.Epps2 = this.Eps2 / (1.0 - this.Eps2);
                        this.EpsH = this.Eps * 0.5;
                        this.C2 = this.C * this.C;
                        break;
                    }
                    case ORMTCOD_OBLATE_ELLIPSOID: 
                    case ORMTCOD_OBLATE_ELLIPSOID_ORIGIN: 
                    case ORMTCOD_TRI_AXIAL_ELLIPSOID: {
                        this.A = rdSet._A;
                        this.F_inv = rdSet._inv_F;
                        this.F = 1.0 / this.F_inv;
                        this.A_inv = 1.0 / this.A;
                        this.A2 = this.A * this.A;
                        this.A2_inv = 1.0 / this.A2;
                        this.B = this.A * (1.0 - this.F);
                        this.B_inv = 1.0 / this.B;
                        this.C = this.A * (1.0 - this.F);
                        this.Eps2 = this.F * (2.0 - this.F);
                        this.Eps = Math.sqrt(this.Eps2);
                        this.Eps25 = 0.25 * this.Eps2;
                        this.Epps2 = this.Eps2 / (1.0 - this.Eps2);
                        this.EpsH = this.Eps * 0.5;
                        this.C2 = this.C * this.C;
                        break;
                    }
                    default: {
                        this.A = 0.0;
                        this.F_inv = 0.0;
                        this.F = 0.0;
                        this.A_inv = 0.0;
                        this.A2 = 0.0;
                        this.A2_inv = 0.0;
                        this.B = 0.0;
                        this.B_inv = 0.0;
                        this.C = 0.0;
                        this.Eps2 = 0.0;
                        this.Eps = 0.0;
                        this.Eps25 = 0.0;
                        this.Epps2 = 0.0;
                        this.EpsH = 0.0;
                        this.C2 = 0.0;
                        break;
                    }
                }
            }
        } else {
            if (orm == SRM_ORM_Code.ORMCOD_EXPERIMENTAL_NGA_MAX) {
                this.A = 6400000.0;
                this.F_inv = 150.0;
                this.F = 1.0 / this.F_inv;
            } else if (orm == SRM_ORM_Code.ORMCOD_EXPERIMENTAL_NGA_SPHERE) {
                this.A = 6366197.7236758135;
                this.F_inv = Double.NaN;
                this.F = 0.0;
            } else {
                this.A = Double.NaN;
                this.F_inv = Double.NaN;
                this.F = Double.NaN;
            }
            this.A_inv = 1.0 / this.A;
            this.A2 = this.A * this.A;
            this.A2_inv = 1.0 / this.A2;
            this.B = this.A * (1.0 - this.F);
            this.B_inv = 1.0 / this.B;
            this.C = this.A * (1.0 - this.F);
            this.Eps2 = this.F * (2.0 - this.F);
            this.Eps = Math.sqrt(this.Eps2);
            this.Eps25 = 0.25 * this.Eps2;
            this.Epps2 = this.Eps2 / (1.0 - this.Eps2);
            this.EpsH = this.Eps * 0.5;
            this.C2 = this.C * this.C;
        }
    }
}

