/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.BaseSRF_MapProjection;
import SRM.Const;
import SRM.Coord3D;
import SRM.Coord3D_LambertConformalConic;
import SRM.CoordSurf;
import SRM.CoordSurf_LambertConformalConic;
import SRM.OrmData;
import SRM.SRF_LCC_Params;
import SRM.SRM_CS_Code;
import SRM.SRM_ORM_Code;
import SRM.SRM_RT_Code;
import SRM.SRM_SRFT_Code;
import SRM.SrfCheck;
import SRM.SrmException;

public class SRF_LambertConformalConic
extends BaseSRF_MapProjection {
    private double _lcc_n = 123.123;
    private double _lcc_mphi1 = 0.0;
    private double _lcc_tphi1 = 0.0;
    private double _com_n = 123.123;
    private SRF_LCC_Params _params = new SRF_LCC_Params();

    public SRF_LambertConformalConic(SRM_ORM_Code orm, SRM_RT_Code rt, SRF_LCC_Params params) throws SrmException {
        this._mySrftCode = SRM_SRFT_Code.SRFTCOD_LAMBERT_CONFORMAL_CONIC;
        this._myCsCode = SRM_CS_Code.CSCOD_LAMBERT_CONFORMAL_CONIC;
        this._orm = orm;
        this._rt = rt;
        this._params.origin_longitude = params.origin_longitude;
        this._params.origin_latitude = params.origin_latitude;
        this._params.latitude1 = params.latitude1;
        this._params.latitude2 = params.latitude2;
        this._params.false_easting = params.false_easting;
        this._params.false_northing = params.false_northing;
        SrfCheck.forLambertConformalConic(this._orm, this._rt, this._params);
    }

    public SRF_LambertConformalConic(SRM_ORM_Code orm, SRM_RT_Code rt, double origin_longitude, double origin_latitude, double latitude1, double latitude2, double false_easting, double false_northing) throws SrmException {
        this._mySrftCode = SRM_SRFT_Code.SRFTCOD_LAMBERT_CONFORMAL_CONIC;
        this._myCsCode = SRM_CS_Code.CSCOD_LAMBERT_CONFORMAL_CONIC;
        this._orm = orm;
        this._rt = rt;
        this._params.origin_longitude = origin_longitude;
        this._params.origin_latitude = origin_latitude;
        this._params.latitude1 = latitude1;
        this._params.latitude2 = latitude2;
        this._params.false_easting = false_easting;
        this._params.false_northing = false_northing;
        SrfCheck.forLambertConformalConic(this._orm, this._rt, this._params);
    }

    public Coord3D createCoordinate3D() {
        return new Coord3D_LambertConformalConic(this, Double.NaN, Double.NaN, Double.NaN);
    }

    public Coord3D createCoordinate3D(double coord_comp1, double coord_comp2, double coord_comp3) {
        return new Coord3D_LambertConformalConic(this, coord_comp1, coord_comp2, coord_comp3);
    }

    public CoordSurf createSurfaceCoordinate() {
        return new CoordSurf_LambertConformalConic(this, Double.NaN, Double.NaN);
    }

    public CoordSurf createSurfaceCoordinate(double coord_comp1, double coord_comp2) {
        return new CoordSurf_LambertConformalConic(this, coord_comp1, coord_comp2);
    }

    public SRF_LCC_Params getSRFParameters() {
        SRF_LCC_Params retParams = new SRF_LCC_Params();
        retParams.origin_longitude = this._params.origin_longitude;
        retParams.origin_latitude = this._params.origin_latitude;
        retParams.latitude1 = this._params.latitude1;
        retParams.latitude2 = this._params.latitude2;
        retParams.false_easting = this._params.false_easting;
        retParams.false_northing = this._params.false_northing;
        return retParams;
    }

    public double get_origin_longitude() {
        return this._params.origin_longitude;
    }

    public double get_origin_latitude() {
        return this._params.origin_latitude;
    }

    public double get_latitude1() {
        return this._params.latitude1;
    }

    public double get_latitude2() {
        return this._params.latitude2;
    }

    public double get_false_easting() {
        return this._params.false_easting;
    }

    public double get_false_northing() {
        return this._params.false_northing;
    }

    public CoordSurf getAssociatedSurfaceCoordinate(Coord3D coord) throws SrmException {
        if (coord.getSRF() != this) {
            throw new SrmException(5, new String("getAssociatedSurfaceCoordinate: Coordinate associated with different SRF"));
        }
        return new CoordSurf_LambertConformalConic(this, coord.getValues()[0], coord.getValues()[1]);
    }

    public Coord3D getPromotedSurfaceCoordinate(CoordSurf surf_coord) throws SrmException {
        if (surf_coord.getSRF() != this) {
            throw new SrmException(5, new String("getPromotedSurfaceCoordinate: Coordinate associated with different SRF"));
        }
        return new Coord3D_LambertConformalConic(this, surf_coord.getValues()[0], surf_coord.getValues()[1], 0.0);
    }

    public boolean isEqual(BaseSRF srf) {
        return srf != null && srf instanceof SRF_LambertConformalConic && this._orm == srf.getOrm() && this._rt == srf.getRt() && this._params.isEqual(((SRF_LambertConformalConic)srf).getSRFParameters());
    }

    public String toString() {
        String retString = new String();
        retString = super.toString() + "\n" + this._params;
        return retString;
    }

    protected double comCalculation(OrmData e_constants, double[] cd_coord) throws SrmException {
        if (this._com_n == 123.123) {
            double latitude1 = this.get_latitude1();
            double latitude2 = this.get_latitude2();
            double sin_lat1 = Math.sin(latitude1);
            double epsilon_times_sin_lat1 = e_constants.Eps * sin_lat1;
            double epsilon_squared_sin_squared_lat1 = epsilon_times_sin_lat1 * epsilon_times_sin_lat1;
            double sin_lat2 = Math.sin(latitude2);
            double epsilon_times_sin_lat2 = e_constants.Eps * sin_lat2;
            double epsilon_squared_sin_squared_lat2 = epsilon_times_sin_lat2 * epsilon_times_sin_lat2;
            double m_phi1 = Math.cos(latitude1) / Math.sqrt(1.0 - epsilon_squared_sin_squared_lat1);
            double m_phi2 = Math.cos(latitude2) / Math.sqrt(1.0 - epsilon_squared_sin_squared_lat2);
            double tan_phi1 = Math.tan(0.7853981633974483 - latitude1 * 0.5) * Math.pow((1.0 + epsilon_times_sin_lat1) / (1.0 - epsilon_times_sin_lat1), e_constants.EpsH);
            double tan_phi2 = Math.tan(0.7853981633974483 - latitude2 * 0.5) * Math.pow((1.0 + epsilon_times_sin_lat2) / (1.0 - epsilon_times_sin_lat2), e_constants.EpsH);
            this._com_n = Const.isEqual(latitude1, latitude2, 1.0E-6) ? Math.sin(latitude1) : (Math.log(m_phi1) - Math.log(m_phi2)) / (Math.log(tan_phi1) - Math.log(tan_phi2));
        }
        double lambda_star = Const.getLambdaStar(cd_coord[0], this.get_origin_longitude());
        return this._com_n * lambda_star;
    }

    protected double pointScaleCalculation(OrmData e_constants, double[] cd_coord) throws SrmException {
        if (this._lcc_n == 123.123) {
            double latitude1 = this.get_latitude1();
            double latitude2 = this.get_latitude2();
            double slat1 = Math.sin(latitude1);
            double eslat1 = e_constants.Eps * slat1;
            double e2slat12 = eslat1 * eslat1;
            double slat2 = Math.sin(latitude2);
            double eslat2 = e_constants.Eps * slat2;
            double e2slat22 = eslat2 * eslat2;
            this._lcc_mphi1 = Math.cos(latitude1) / Math.sqrt(1.0 - e2slat12);
            double mphi2 = Math.cos(latitude2) / Math.sqrt(1.0 - e2slat22);
            this._lcc_tphi1 = Math.tan(0.7853981633974483 - latitude1 * 0.5) * Math.pow((1.0 + eslat1) / (1.0 - eslat1), e_constants.EpsH);
            double tphi2 = Math.tan(0.7853981633974483 - latitude2 * 0.5) * Math.pow((1.0 + eslat2) / (1.0 - eslat2), e_constants.EpsH);
            this._lcc_n = Const.isEqual(latitude1, latitude2, 1.0E-6) ? slat1 : (Math.log(this._lcc_mphi1) - Math.log(mphi2)) / (Math.log(this._lcc_tphi1) - Math.log(tphi2));
        }
        double sphi = Math.sin(cd_coord[1]);
        double esphi = e_constants.Eps * sphi;
        double tphi = Math.tan(0.7853981633974483 - cd_coord[1] * 0.5) * Math.pow((1.0 + esphi) / (1.0 - esphi), e_constants.EpsH);
        double mphi = Math.cos(cd_coord[1]) / Math.sqrt(1.0 - esphi * esphi);
        return this._lcc_mphi1 / mphi * Math.pow(tphi / this._lcc_tphi1, this._lcc_n);
    }
}

