/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.BaseSRF_WithTangentPlaneSurface;
import SRM.Coord3D;
import SRM.Coord3D_LocalTangentSpaceEuclidean;
import SRM.CoordSurf;
import SRM.CoordSurf_LocalTangentSpaceEuclidean;
import SRM.SRF_LTSE_Params;
import SRM.SRM_CS_Code;
import SRM.SRM_ORM_Code;
import SRM.SRM_RT_Code;
import SRM.SRM_SRFT_Code;
import SRM.SrfCheck;
import SRM.SrmException;

public class SRF_LocalTangentSpaceEuclidean
extends BaseSRF_WithTangentPlaneSurface {
    private SRF_LTSE_Params _params = new SRF_LTSE_Params();

    public SRF_LocalTangentSpaceEuclidean(SRM_ORM_Code orm, SRM_RT_Code rt, SRF_LTSE_Params params) throws SrmException {
        SrfCheck.forLocalTangentSpaceEuclidean(orm, rt, params);
        this._mySrftCode = SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_EUCLIDEAN;
        this._myCsCode = SRM_CS_Code.CSCOD_LOCOCENT_EUCLIDEAN_3D;
        this._orm = orm;
        this._rt = rt;
        this._params.geodetic_longitude = params.geodetic_longitude;
        this._params.geodetic_latitude = params.geodetic_latitude;
        this._params.azimuth = params.azimuth;
        this._params.x_false_origin = params.x_false_origin;
        this._params.y_false_origin = params.y_false_origin;
        this._params.height_offset = params.height_offset;
    }

    public SRF_LocalTangentSpaceEuclidean(SRM_ORM_Code orm, SRM_RT_Code rt, double geodetic_longitude, double geodetic_latitude, double azimuth, double x_false_origin, double y_false_origin, double height_offset) throws SrmException {
        this._mySrftCode = SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_EUCLIDEAN;
        this._myCsCode = SRM_CS_Code.CSCOD_LOCOCENT_EUCLIDEAN_3D;
        this._orm = orm;
        this._rt = rt;
        this._params.geodetic_longitude = geodetic_longitude;
        this._params.geodetic_latitude = geodetic_latitude;
        this._params.azimuth = azimuth;
        this._params.x_false_origin = x_false_origin;
        this._params.y_false_origin = y_false_origin;
        this._params.height_offset = height_offset;
        SrfCheck.forLocalTangentSpaceEuclidean(this._orm, this._rt, this._params);
    }

    public Coord3D createCoordinate3D() {
        return new Coord3D_LocalTangentSpaceEuclidean(this, Double.NaN, Double.NaN, Double.NaN);
    }

    public Coord3D createCoordinate3D(double coord_comp1, double coord_comp2, double coord_comp3) {
        return new Coord3D_LocalTangentSpaceEuclidean(this, coord_comp1, coord_comp2, coord_comp3);
    }

    public CoordSurf createSurfaceCoordinate() {
        return new CoordSurf_LocalTangentSpaceEuclidean(this, Double.NaN, Double.NaN);
    }

    public CoordSurf createSurfaceCoordinate(double coord_comp1, double coord_comp2) {
        return new CoordSurf_LocalTangentSpaceEuclidean(this, coord_comp1, coord_comp2);
    }

    public SRF_LTSE_Params getSRFParameters() {
        SRF_LTSE_Params retParams = new SRF_LTSE_Params();
        retParams.geodetic_longitude = this._params.geodetic_longitude;
        retParams.geodetic_latitude = this._params.geodetic_latitude;
        retParams.azimuth = this._params.azimuth;
        retParams.x_false_origin = this._params.x_false_origin;
        retParams.y_false_origin = this._params.y_false_origin;
        retParams.height_offset = this._params.height_offset;
        return retParams;
    }

    public double get_geodetic_longitude() {
        return this._params.geodetic_longitude;
    }

    public double get_geodetic_latitude() {
        return this._params.geodetic_latitude;
    }

    public double get_azimuth() {
        return this._params.azimuth;
    }

    public double get_x_false_origin() {
        return this._params.x_false_origin;
    }

    public double get_y_false_origin() {
        return this._params.y_false_origin;
    }

    public double get_height_offset() {
        return this._params.height_offset;
    }

    public CoordSurf getAssociatedSurfaceCoordinate(Coord3D coord) throws SrmException {
        if (coord.getSRF() != this) {
            throw new SrmException(5, new String("getAssociatedSurfaceCoordinate: Coordinate associated with different SRF"));
        }
        return new CoordSurf_LocalTangentSpaceEuclidean(this, coord.getValues()[0], coord.getValues()[1]);
    }

    public Coord3D getPromotedSurfaceCoordinate(CoordSurf surf_coord) throws SrmException {
        if (surf_coord.getSRF() != this) {
            throw new SrmException(5, new String("getPromotedSurfaceCoordinate: Coordinate associated with different SRF"));
        }
        return new Coord3D_LocalTangentSpaceEuclidean(this, surf_coord.getValues()[0], surf_coord.getValues()[1], 0.0);
    }

    public boolean isEqual(BaseSRF srf) {
        return srf != null && srf instanceof SRF_LocalTangentSpaceEuclidean && this._orm == srf.getOrm() && this._rt == srf.getRt() && this._params.isEqual(((SRF_LocalTangentSpaceEuclidean)srf).getSRFParameters());
    }

    public String toString() {
        String retString = new String();
        retString = retString + super.toString() + "\n" + this._params;
        return retString;
    }
}

