/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.BaseSRF_MapProjection;
import SRM.Const;
import SRM.Coord3D;
import SRM.Coord3D_TransverseMercator;
import SRM.CoordSurf;
import SRM.CoordSurf_TransverseMercator;
import SRM.OrmData;
import SRM.SRF_TM_Params;
import SRM.SRM_CS_Code;
import SRM.SRM_ORM_Code;
import SRM.SRM_RT_Code;
import SRM.SRM_SRFT_Code;
import SRM.SrfCheck;
import SRM.SrmException;

public class SRF_TransverseMercator
extends BaseSRF_MapProjection {
    private SRF_TM_Params _params = new SRF_TM_Params();

    public SRF_TransverseMercator(SRM_ORM_Code orm, SRM_RT_Code rt, SRF_TM_Params params) throws SrmException {
        this._mySrftCode = SRM_SRFT_Code.SRFTCOD_TRANSVERSE_MERCATOR;
        this._myCsCode = SRM_CS_Code.CSCOD_TRANSVERSE_MERCATOR;
        this._orm = orm;
        this._rt = rt;
        this._params.origin_longitude = params.origin_longitude;
        this._params.origin_latitude = params.origin_latitude;
        this._params.central_scale = params.central_scale;
        this._params.false_easting = params.false_easting;
        this._params.false_northing = params.false_northing;
        SrfCheck.forTransverseMercator(this._orm, this._rt, this._params);
    }

    public SRF_TransverseMercator(SRM_ORM_Code orm, SRM_RT_Code rt, double origin_longitude, double origin_latitude, double central_scale, double false_easting, double false_northing) throws SrmException {
        this._mySrftCode = SRM_SRFT_Code.SRFTCOD_TRANSVERSE_MERCATOR;
        this._myCsCode = SRM_CS_Code.CSCOD_TRANSVERSE_MERCATOR;
        this._orm = orm;
        this._rt = rt;
        this._params.origin_longitude = origin_longitude;
        this._params.origin_latitude = origin_latitude;
        this._params.central_scale = central_scale;
        this._params.false_easting = false_easting;
        this._params.false_northing = false_northing;
        SrfCheck.forTransverseMercator(this._orm, this._rt, this._params);
    }

    public Coord3D createCoordinate3D() {
        return new Coord3D_TransverseMercator(this, Double.NaN, Double.NaN, Double.NaN);
    }

    public Coord3D createCoordinate3D(double coord_comp1, double coord_comp2, double coord_comp3) {
        return new Coord3D_TransverseMercator(this, coord_comp1, coord_comp2, coord_comp3);
    }

    public CoordSurf createSurfaceCoordinate() {
        return new CoordSurf_TransverseMercator(this, Double.NaN, Double.NaN);
    }

    public CoordSurf createSurfaceCoordinate(double coord_comp1, double coord_comp2) {
        return new CoordSurf_TransverseMercator(this, coord_comp1, coord_comp2);
    }

    public SRF_TM_Params getSRFParameters() {
        SRF_TM_Params retParams = new SRF_TM_Params();
        retParams.origin_longitude = this._params.origin_longitude;
        retParams.origin_latitude = this._params.origin_latitude;
        retParams.central_scale = this._params.central_scale;
        retParams.false_easting = this._params.false_easting;
        retParams.false_northing = this._params.false_northing;
        return retParams;
    }

    public double get_origin_longitude() {
        return this._params.origin_longitude;
    }

    public double get_origin_latitude() {
        return this._params.origin_latitude;
    }

    public double get_central_scale() {
        return this._params.central_scale;
    }

    public double get_false_easting() {
        return this._params.false_easting;
    }

    public double get_false_northing() {
        return this._params.false_northing;
    }

    public CoordSurf getAssociatedSurfaceCoordinate(Coord3D coord) throws SrmException {
        if (coord.getSRF() != this) {
            throw new SrmException(5, new String("getAssociatedSurfaceCoordinate: Coordinate associated with different SRF"));
        }
        return new CoordSurf_TransverseMercator(this, coord.getValues()[0], coord.getValues()[1]);
    }

    public Coord3D getPromotedSurfaceCoordinate(CoordSurf surf_coord) throws SrmException {
        if (surf_coord.getSRF() != this) {
            throw new SrmException(5, new String("getPromotedSurfaceCoordinate: Coordinate associated with different SRF"));
        }
        return new Coord3D_TransverseMercator(this, surf_coord.getValues()[0], surf_coord.getValues()[1], 0.0);
    }

    public boolean isEqual(BaseSRF srf) {
        return srf != null && srf instanceof SRF_TransverseMercator && this._orm == srf.getOrm() && this._rt == srf.getRt() && this._params.isEqual(((SRF_TransverseMercator)srf).getSRFParameters());
    }

    public String toString() {
        String retString = new String();
        retString = retString + super.toString() + "\n";
        retString = retString + this._params;
        return retString;
    }

    protected double comCalculation(OrmData e_constants, double[] cd_coord) throws SrmException {
        double ret_com = 0.0;
        if (e_constants.Eps2 == 0.0) {
            ret_com = Math.tan(cd_coord[0]) * Math.sin(cd_coord[1]);
        } else {
            double CON1 = 0.3333333333333333;
            double CON2 = 0.06666666666666667;
            double CON3 = 0.2;
            double CON4 = 0.006349206349206349;
            double CON5 = 0.09523809523809523;
            double CON6 = 0.14285714285714285;
            double two_thirds = 0.6666666666666666;
            double seventeen_thirds = 5.666666666666667;
            double ten_thirds = 3.3333333333333335;
            double lambda_star = Const.getLambdaStar(cd_coord[0], this.get_origin_longitude());
            double cos_phi = Math.cos(cd_coord[1]);
            double CONL1 = two_thirds * e_constants.Epps2 * e_constants.Epps2;
            double CONL2 = seventeen_thirds * e_constants.Epps2 * e_constants.Epps2;
            double CONL3 = 2.0 * e_constants.Epps2;
            double CONL4 = ten_thirds * e_constants.Epps2 * e_constants.Epps2;
            double CONL5 = CON3 - e_constants.Epps2;
            double CONL6 = CONL3 - CONL4;
            double CN2 = cos_phi * cos_phi;
            double D2 = lambda_star * lambda_star;
            double T2 = CON1 + CN2 * (e_constants.Epps2 + CONL1 * CN2);
            double T4 = -CON2 + CN2 * (CONL5 + CN2 * (CONL6 + CONL2 * CN2));
            double T6 = CON4 + CN2 * (-CON5 + CON6 * CN2);
            ret_com = lambda_star * Math.sin(cd_coord[1]) * (1.0 + CN2 * D2 * (T2 + D2 * (T4 + D2 * T6)));
        }
        return ret_com;
    }

    protected double pointScaleCalculation(OrmData e_constants, double[] cd_coord) throws SrmException {
        double ret_ps = 0.0;
        double cos_phi = Math.cos(cd_coord[1]);
        double CN2 = cos_phi * cos_phi;
        double lambda_star = Const.getLambdaStar(cd_coord[0], this.get_origin_longitude());
        if (e_constants.Eps2 == 0.0) {
            double s_lambda_star = Math.sin(lambda_star);
            ret_ps = this.get_central_scale() / Math.sqrt(1.0 - CN2 * s_lambda_star * s_lambda_star);
        } else {
            double CON1 = 0.16666666666666666;
            double CON2 = 0.022222222222222223;
            double CON3 = 0.25;
            double CON4 = 0.3125;
            double three_eighths = 0.375;
            double seven_fourths = 1.75;
            double seven_sixths = 1.1666666666666667;
            double sixtyone_twentyfourths = 2.5416666666666665;
            double CONL1 = 0.5 * e_constants.Epps2;
            double CONL2 = three_eighths - seven_sixths * e_constants.Epps2;
            double CONL3 = seven_fourths * e_constants.Epps2 - 2.0 * e_constants.Epps2 * e_constants.Epps2;
            double CONL4 = sixtyone_twentyfourths * e_constants.Epps2 * e_constants.Epps2;
            double T2 = 0.5 + CONL1 * CN2;
            double T4 = -CON1 + CN2 * (CONL2 + CN2 * (CONL3 + CONL4 * CN2));
            double T6 = CON2 - CN2 * (CON3 + CON4 * CN2);
            double D2 = lambda_star * lambda_star;
            ret_ps = this.get_central_scale() * (1.0 + CN2 * D2 * (T2 + D2 * (T4 + D2 * T6)));
        }
        return ret_ps;
    }
}

