/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.Const;

public class SRM_Euler_Angles_ZXZ_Params {
    public double spin = 0.0;
    public double nutation = 0.0;
    public double precession = 0.0;

    public SRM_Euler_Angles_ZXZ_Params() {
    }

    public SRM_Euler_Angles_ZXZ_Params(double spin, double nutation, double precession) {
        this.spin = spin;
        this.nutation = nutation;
        this.precession = precession;
    }

    public SRM_Euler_Angles_ZXZ_Params(SRM_Euler_Angles_ZXZ_Params params) {
        this.spin = params.spin;
        this.nutation = params.nutation;
        this.precession = params.precession;
    }

    public static final boolean isEquiv(SRM_Euler_Angles_ZXZ_Params a, SRM_Euler_Angles_ZXZ_Params b, double tolerance) {
        return Const.areEqualAngles(a.nutation, b.nutation, tolerance) && Const.areEqualAngles(a.nutation, Math.PI, tolerance) && Const.areEqualAngles(a.spin - a.precession, b.spin - b.precession, tolerance) || Const.areEqualAngles(a.nutation, b.nutation, tolerance) && Const.areEqualAngles(a.nutation, 0.0, tolerance) && Const.areEqualAngles(a.spin + a.precession, b.spin + b.precession, tolerance) || Const.areEqualAngles(a.nutation, b.nutation, tolerance) && Const.areEqualAngles(a.spin, b.spin, tolerance) && Const.areEqualAngles(a.precession, b.precession, tolerance) || Const.areEqualAngles(a.nutation + b.nutation, Math.PI * 2, tolerance) && Const.areEqualAngles(Math.abs(a.spin - b.spin), Math.PI, tolerance) && Const.areEqualAngles(Math.abs(a.precession - b.precession), Math.PI, tolerance);
    }

    public boolean valid() {
        return Const.inFourPiRange(this.spin) && Const.inFourPiRange(this.nutation) && Const.inFourPiRange(this.precession);
    }

    public String toString() {
        return "[ " + this.spin + ", " + this.nutation + ", " + this.precession + " ]";
    }
}

