/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.Const;
import SRM.CoordCheck;
import SRM.Lsr2Conv;
import SRM.Lsr3Conv;
import SRM.OrmDataSet;
import SRM.SRF_EC_Params;
import SRM.SRF_LCC_Params;
import SRM.SRF_LSR_2D_Params;
import SRM.SRF_LSR_3D_Params;
import SRM.SRF_LTSE_Params;
import SRM.SRF_LT_Params;
import SRM.SRF_M_Params;
import SRM.SRF_OM_Params;
import SRM.SRF_PS_Params;
import SRM.SRF_TM_Params;
import SRM.SRM_OBRS_Code;
import SRM.SRM_ORM_Code;
import SRM.SRM_Polar_Aspect;
import SRM.SRM_RT_Code;
import SRM.SrmException;

class SrfCheck {
    SrfCheck() {
    }

    protected static void forCelestiocentric(SRM_ORM_Code orm, SRM_RT_Code rt) throws SrmException {
        if (orm.toInt() > 0) {
            switch (OrmDataSet.getElem((SRM_ORM_Code)orm)._orm_template) {
                case ORMTCOD_SPHERE: 
                case ORMTCOD_OBLATE_ELLIPSOID: 
                case ORMTCOD_SPHERE_ORIGIN: 
                case ORMTCOD_OBLATE_ELLIPSOID_ORIGIN: 
                case ORMTCOD_PROLATE_ELLIPSOID: 
                case ORMTCOD_TRI_AXIAL_ELLIPSOID: 
                case ORMTCOD_BI_AXIS_ORIGIN_3D: 
                case ORMTCOD_TRI_PLANE: {
                    break;
                }
                default: {
                    throw new SrmException(3, "SRF_Celestiocentric: Invalid ORM for SRF - not 3D");
                }
            }
        }
        if (orm == SRM_ORM_Code.ORMCOD_ABSTRACT_3D || !Const.isValidOrmRt(orm, rt)) {
            throw new SrmException(3, "SRF_Celestiocentric: Invalid ORM/RT pair");
        }
    }

    protected static void forLocalSpaceRectangular3D(SRM_ORM_Code orm, SRM_RT_Code rt, SRF_LSR_3D_Params params) throws SrmException {
        if (orm != SRM_ORM_Code.ORMCOD_ABSTRACT_3D || !Const.isValidOrmRt(orm, rt)) {
            throw new SrmException(3, "SRF_LocalSpaceRectangular3D: Invalid ORM/RT pair");
        }
        Lsr3Conv.compute_F_u_v_w(params);
    }

    protected static void forCelestiodetic(SRM_ORM_Code orm, SRM_RT_Code rt) throws SrmException {
        if (orm.toInt() > 0) {
            switch (OrmDataSet.getElem((SRM_ORM_Code)orm)._orm_template) {
                case ORMTCOD_SPHERE: 
                case ORMTCOD_OBLATE_ELLIPSOID: 
                case ORMTCOD_SPHERE_ORIGIN: 
                case ORMTCOD_OBLATE_ELLIPSOID_ORIGIN: {
                    break;
                }
                default: {
                    throw new SrmException(3, "SRF_Celestiodetic: Invalid ORM for SRF");
                }
            }
        }
        if (orm == SRM_ORM_Code.ORMCOD_ABSTRACT_3D || !Const.isValidOrmRt(orm, rt)) {
            throw new SrmException(3, "SRF_Celestiodetic: Invalid ORM/RT pair");
        }
    }

    protected static void forPlanetodetic(SRM_ORM_Code orm, SRM_RT_Code rt) throws SrmException {
        if (orm.toInt() > 0) {
            switch (OrmDataSet.getElem((SRM_ORM_Code)orm)._orm_template) {
                case ORMTCOD_SPHERE: 
                case ORMTCOD_OBLATE_ELLIPSOID: 
                case ORMTCOD_SPHERE_ORIGIN: 
                case ORMTCOD_OBLATE_ELLIPSOID_ORIGIN: {
                    break;
                }
                default: {
                    throw new SrmException(3, "SRF_Planetodetic: Invalid ORM for SRF");
                }
            }
        }
        if (orm == SRM_ORM_Code.ORMCOD_ABSTRACT_3D || !Const.isValidOrmRt(orm, rt)) {
            throw new SrmException(3, "SRF_Planetodetic: Invalid ORM/RT pair");
        }
    }

    protected static void forLocalTangentSpaceEuclidean(SRM_ORM_Code orm, SRM_RT_Code rt, SRF_LTSE_Params params) throws SrmException {
        if (orm.toInt() > 0) {
            switch (OrmDataSet.getElem((SRM_ORM_Code)orm)._orm_template) {
                case ORMTCOD_SPHERE: 
                case ORMTCOD_OBLATE_ELLIPSOID: 
                case ORMTCOD_SPHERE_ORIGIN: 
                case ORMTCOD_OBLATE_ELLIPSOID_ORIGIN: {
                    break;
                }
                default: {
                    throw new SrmException(3, "SRF_LocalTangentSpaceEuclidean: Invalid ORM for SRF");
                }
            }
        }
        if (orm != SRM_ORM_Code.ORMCOD_ABSTRACT_3D && Const.isValidOrmRt(orm, rt)) {
            if (!CoordCheck.forCelestiodeticSurface(params.geodetic_longitude, params.geodetic_latitude) || !Const.isWellFormedAzimuth(params.azimuth)) {
                throw new SrmException(3, new String("SRF_LocalTangentSpaceEuclidean: Invalid SRF parameters"));
            }
        } else {
            throw new SrmException(3, "SRF_LocalTangentSpaceEuclidean: Invalid ORM/RT pair");
        }
    }

    protected static void forLocalTangentSpaceAzimuthalSpherical(SRM_ORM_Code orm, SRM_RT_Code rt, SRF_LT_Params params) throws SrmException {
        if (orm.toInt() > 0) {
            switch (OrmDataSet.getElem((SRM_ORM_Code)orm)._orm_template) {
                case ORMTCOD_SPHERE: 
                case ORMTCOD_OBLATE_ELLIPSOID: 
                case ORMTCOD_SPHERE_ORIGIN: 
                case ORMTCOD_OBLATE_ELLIPSOID_ORIGIN: {
                    break;
                }
                default: {
                    throw new SrmException(3, "SRF_LocalTangentSpaceAzimuthalSpherical: Invalid ORM for SRF");
                }
            }
        }
        if (orm != SRM_ORM_Code.ORMCOD_ABSTRACT_3D && Const.isValidOrmRt(orm, rt)) {
            if (!CoordCheck.forCelestiodeticSurface(params.geodetic_longitude, params.geodetic_latitude) || !Const.isWellFormedAzimuth(params.azimuth)) {
                throw new SrmException(3, new String("SRF_LocalTangentSpaceAzimuthalSpherical: Invalid SRF parameters"));
            }
        } else {
            throw new SrmException(3, "SRF_LocalTangentSpaceAzimuthalSpherical: Invalid ORM/RT pair");
        }
    }

    protected static void forLocalTangentSpaceCylindrical(SRM_ORM_Code orm, SRM_RT_Code rt, SRF_LT_Params params) throws SrmException {
        if (orm.toInt() > 0) {
            switch (OrmDataSet.getElem((SRM_ORM_Code)orm)._orm_template) {
                case ORMTCOD_SPHERE: 
                case ORMTCOD_OBLATE_ELLIPSOID: 
                case ORMTCOD_SPHERE_ORIGIN: 
                case ORMTCOD_OBLATE_ELLIPSOID_ORIGIN: {
                    break;
                }
                default: {
                    throw new SrmException(3, "SRF_LocalTangentSpaceCylindrical: Invalid ORM for SRF");
                }
            }
        }
        if (orm != SRM_ORM_Code.ORMCOD_ABSTRACT_3D && Const.isValidOrmRt(orm, rt)) {
            if (!CoordCheck.forCelestiodeticSurface(params.geodetic_longitude, params.geodetic_latitude) || !Const.isWellFormedAzimuth(params.azimuth)) {
                throw new SrmException(3, new String("SRF_LocalTangentSpaceCylindrical: Invalid SRF parameters"));
            }
        } else {
            throw new SrmException(3, "SRF_LocalTangentSpaceCylindrical: Invalid ORM/RT pair");
        }
    }

    protected static void forLococentricEuclidean3D(SRM_ORM_Code orm, SRM_RT_Code rt, double[] lococentre, double[] primary_axis, double[] secondary_axis) throws SrmException {
        if (orm.toInt() > 0) {
            switch (OrmDataSet.getElem((SRM_ORM_Code)orm)._orm_template) {
                case ORMTCOD_SPHERE: 
                case ORMTCOD_OBLATE_ELLIPSOID: 
                case ORMTCOD_SPHERE_ORIGIN: 
                case ORMTCOD_OBLATE_ELLIPSOID_ORIGIN: 
                case ORMTCOD_PROLATE_ELLIPSOID: 
                case ORMTCOD_TRI_AXIAL_ELLIPSOID: 
                case ORMTCOD_BI_AXIS_ORIGIN_3D: 
                case ORMTCOD_TRI_PLANE: {
                    break;
                }
                default: {
                    throw new SrmException(3, "SRF_LococentricEuclidean3D: Invalid ORM for SRF - not 3D");
                }
            }
        }
        if (Const.isValidOrmRt(orm, rt)) {
            if (!Const.isEqual(Const.vectDotProd(primary_axis, secondary_axis), 0.0, 1.0E-6)) {
                throw new SrmException(3, "SRF_LococentricEuclidean3D: Vectors primary_axis and secondary_axis are not orthogonal");
            }
            if (!Const.isEqual(Const.vectDotProd(primary_axis, primary_axis), 1.0, 1.0E-6)) {
                throw new SrmException(3, "SRF_LococentricEuclidean3D: Vector primary_axis is not normalized");
            }
            if (!Const.isEqual(Const.vectDotProd(secondary_axis, secondary_axis), 1.0, 1.0E-6)) {
                throw new SrmException(3, "SRF_LococentricEuclidean3D: Vector secondary_axis is not normalized");
            }
        } else {
            throw new SrmException(3, "SRF_LococentricEuclidean3D: Invalid ORM/RT pair");
        }
    }

    protected static void forCelestiomagnetic(SRM_ORM_Code orm, SRM_RT_Code rt) throws SrmException {
        if (orm.toInt() > 0) {
            switch (OrmDataSet.getElem((SRM_ORM_Code)orm)._orm_template) {
                case ORMTCOD_BI_AXIS_ORIGIN_3D: {
                    if (OrmDataSet.getElem((SRM_ORM_Code)orm)._obrs_code == SRM_OBRS_Code.OBRSCOD_CELESTIOMAGNETIC) break;
                    throw new SrmException(3, "SRF_Celestiomagnetic: Invalid ORM for SRF");
                }
                default: {
                    throw new SrmException(3, "SRF_Celestiomagnetic: Invalid ORM for SRF");
                }
            }
        }
        if (!Const.isValidOrmRt(orm, rt)) {
            throw new SrmException(3, "SRF_Celestiomagnetic: Invalid ORM/RT pair");
        }
    }

    protected static void forEquatorialInertial(SRM_ORM_Code orm, SRM_RT_Code rt) throws SrmException {
        if (orm.toInt() > 0) {
            switch (OrmDataSet.getElem((SRM_ORM_Code)orm)._orm_template) {
                case ORMTCOD_BI_AXIS_ORIGIN_3D: {
                    if (OrmDataSet.getElem((SRM_ORM_Code)orm)._obrs_code == SRM_OBRS_Code.OBRSCOD_EQUATORIAL_INERTIAL) break;
                    throw new SrmException(3, "SRF_EquatorialInertial: Invalid ORM for SRF");
                }
                default: {
                    throw new SrmException(3, "SRF_EquatorialInertial: Invalid ORM for SRF");
                }
            }
        }
        if (!Const.isValidOrmRt(orm, rt)) {
            throw new SrmException(3, "SRF_EquatorialInertial: Invalid ORM/RT pair");
        }
    }

    protected static void forSolarEcliptic(SRM_ORM_Code orm, SRM_RT_Code rt) throws SrmException {
        if (orm.toInt() > 0) {
            switch (OrmDataSet.getElem((SRM_ORM_Code)orm)._orm_template) {
                case ORMTCOD_BI_AXIS_ORIGIN_3D: {
                    if (OrmDataSet.getElem((SRM_ORM_Code)orm)._obrs_code == SRM_OBRS_Code.OBRSCOD_SOLAR_ECLIPTIC) break;
                    throw new SrmException(3, "SRF_SolarEcliptic: Invalid ORM for SRF");
                }
                default: {
                    throw new SrmException(3, "SRF_SolarEcliptic: Invalid ORM for SRF");
                }
            }
        }
        if (!Const.isValidOrmRt(orm, rt)) {
            throw new SrmException(3, "SRF_SolarEcliptic: Invalid ORM/RT pair");
        }
    }

    protected static void forSolarEquatorial(SRM_ORM_Code orm, SRM_RT_Code rt) throws SrmException {
        if (orm.toInt() > 0) {
            switch (OrmDataSet.getElem((SRM_ORM_Code)orm)._orm_template) {
                case ORMTCOD_BI_AXIS_ORIGIN_3D: {
                    if (OrmDataSet.getElem((SRM_ORM_Code)orm)._obrs_code == SRM_OBRS_Code.OBRSCOD_SOLAR_EQUATORIAL) break;
                    throw new SrmException(3, "SRF_SolarEquatorial: Invalid ORM for SRF");
                }
                default: {
                    throw new SrmException(3, "SRF_SolarEquatorial: Invalid ORM for SRF");
                }
            }
        }
        if (!Const.isValidOrmRt(orm, rt)) {
            throw new SrmException(3, "SRF_SolarEquatorial: Invalid ORM/RT pair");
        }
    }

    protected static void forSolarMagneticEcliptic(SRM_ORM_Code orm, SRM_RT_Code rt) throws SrmException {
        if (orm.toInt() > 0) {
            switch (OrmDataSet.getElem((SRM_ORM_Code)orm)._orm_template) {
                case ORMTCOD_BI_AXIS_ORIGIN_3D: {
                    if (OrmDataSet.getElem((SRM_ORM_Code)orm)._obrs_code == SRM_OBRS_Code.OBRSCOD_SOLAR_MAGNETIC_ECLIPTIC) break;
                    throw new SrmException(3, "SRF_SolarMagneticEcliptic: Invalid ORM for SRF");
                }
                default: {
                    throw new SrmException(3, "SRF_SolarMagneticEcliptic: Invalid ORM for SRF");
                }
            }
        }
        if (!Const.isValidOrmRt(orm, rt)) {
            throw new SrmException(3, "SRF_SolarMagneticEcliptic: Invalid ORM/RT pair");
        }
    }

    protected static void forSolarMagneticDipole(SRM_ORM_Code orm, SRM_RT_Code rt) throws SrmException {
        if (orm.toInt() > 0) {
            switch (OrmDataSet.getElem((SRM_ORM_Code)orm)._orm_template) {
                case ORMTCOD_BI_AXIS_ORIGIN_3D: {
                    if (OrmDataSet.getElem((SRM_ORM_Code)orm)._obrs_code == SRM_OBRS_Code.OBRSCOD_SOLAR_MAGNETIC_DIPOLE) break;
                    throw new SrmException(3, "SRF_SolarMagneticDipole: Invalid ORM for SRF");
                }
                default: {
                    throw new SrmException(3, "SRF_SolarMagneticDipole: Invalid ORM for SRF");
                }
            }
        }
        if (!Const.isValidOrmRt(orm, rt)) {
            throw new SrmException(3, "SRF_SolarMagneticDipole: Invalid ORM/RT pair");
        }
    }

    protected static void forHeliosphericAriesEcliptic(SRM_ORM_Code orm, SRM_RT_Code rt) throws SrmException {
        if (orm.toInt() > 0) {
            switch (OrmDataSet.getElem((SRM_ORM_Code)orm)._orm_template) {
                case ORMTCOD_BI_AXIS_ORIGIN_3D: {
                    if (OrmDataSet.getElem((SRM_ORM_Code)orm)._obrs_code == SRM_OBRS_Code.OBRSCOD_HELIOCENTRIC_ARIES_ECLIPTIC) break;
                    throw new SrmException(3, "SRF_HeliosphericAriesEcliptic: Invalid ORM for SRF");
                }
                default: {
                    throw new SrmException(3, "SRF_HeliosphericAriesEcliptic: Invalid ORM for SRF");
                }
            }
        }
        if (!Const.isValidOrmRt(orm, rt)) {
            throw new SrmException(3, "SRF_HeliosphericAriesEcliptic: Invalid ORM/RT pair");
        }
    }

    protected static void forHeliosphericEarthEcliptic(SRM_ORM_Code orm, SRM_RT_Code rt) throws SrmException {
        if (orm.toInt() > 0) {
            switch (OrmDataSet.getElem((SRM_ORM_Code)orm)._orm_template) {
                case ORMTCOD_BI_AXIS_ORIGIN_3D: {
                    if (OrmDataSet.getElem((SRM_ORM_Code)orm)._obrs_code == SRM_OBRS_Code.OBRSCOD_HELIOCENT_PLANET_ECLIPTIC) break;
                    throw new SrmException(3, "SRF_HeliosphericEarthEcliptic: Invalid ORM for SRF");
                }
                default: {
                    throw new SrmException(3, "SRF_HeliosphericEarthEcliptic: Invalid ORM for SRF");
                }
            }
        }
        if (!Const.isValidOrmRt(orm, rt)) {
            throw new SrmException(3, "SRF_HeliosphericEarthEcliptic: Invalid ORM/RT pair");
        }
    }

    protected static void forHeliosphericEarthEquatorial(SRM_ORM_Code orm, SRM_RT_Code rt) throws SrmException {
        if (orm.toInt() > 0) {
            switch (OrmDataSet.getElem((SRM_ORM_Code)orm)._orm_template) {
                case ORMTCOD_BI_AXIS_ORIGIN_3D: {
                    if (OrmDataSet.getElem((SRM_ORM_Code)orm)._obrs_code == SRM_OBRS_Code.OBRSCOD_HELIOCENT_PLANET_EQUATORIAL) break;
                    throw new SrmException(3, "SRF_HeliosphericEarthEquatorial: Invalid ORM for SRF");
                }
                default: {
                    throw new SrmException(3, "SRF_HeliosphericEarthEquatorial: Invalid ORM for SRF");
                }
            }
        }
        if (!Const.isValidOrmRt(orm, rt)) {
            throw new SrmException(3, "SRF_HeliosphericEarthEquatorial: Invalid ORM/RT pair");
        }
    }

    protected static void forMercator(SRM_ORM_Code orm, SRM_RT_Code rt, SRF_M_Params params) throws SrmException {
        if (orm.toInt() > 0) {
            switch (OrmDataSet.getElem((SRM_ORM_Code)orm)._orm_template) {
                case ORMTCOD_SPHERE: 
                case ORMTCOD_OBLATE_ELLIPSOID: 
                case ORMTCOD_SPHERE_ORIGIN: 
                case ORMTCOD_OBLATE_ELLIPSOID_ORIGIN: {
                    break;
                }
                default: {
                    throw new SrmException(3, "SRF_Mercator: Invalid ORM for SRF");
                }
            }
        }
        if (orm != SRM_ORM_Code.ORMCOD_ABSTRACT_3D && Const.isValidOrmRt(orm, rt)) {
            if (!Const.isWellFormedLongitude(params.origin_longitude) || !Const.isWellFormedScale(params.central_scale)) {
                throw new SrmException(3, "SRF_Mercator: Invalid SRF parameters");
            }
        } else {
            throw new SrmException(3, "SRF_Mercator: Invalid ORM/RT pair");
        }
    }

    protected static void forObliqueMercatorSpherical(SRM_ORM_Code orm, SRM_RT_Code rt, SRF_OM_Params params) throws SrmException {
        if (orm.toInt() > 0) {
            switch (OrmDataSet.getElem((SRM_ORM_Code)orm)._orm_template) {
                case ORMTCOD_SPHERE: 
                case ORMTCOD_SPHERE_ORIGIN: {
                    break;
                }
                default: {
                    throw new SrmException(3, "SRF_ObliqueMercatorSpherical: Invalid ORM for SRF - must be spherical");
                }
            }
        }
        if (orm != SRM_ORM_Code.ORMCOD_ABSTRACT_3D && Const.isValidOrmRt(orm, rt)) {
            if (!(Const.isWellFormedLongitude(params.longitude1) && Const.isWellFormedLatitude(params.latitude1) && Const.isWellFormedLongitude(params.longitude2) && Const.isWellFormedLatitude(params.latitude2) && Const.isWellFormedScale(params.central_scale))) {
                throw new SrmException(3, new String("SRF_ObliqueMercator: Invalid SRF parameters"));
            }
        } else {
            throw new SrmException(3, "SRF_ObliqueMercatorSpherical: Invalid ORM/RT pair");
        }
    }

    protected static void forTransverseMercator(SRM_ORM_Code orm, SRM_RT_Code rt, SRF_TM_Params params) throws SrmException {
        if (orm.toInt() > 0) {
            switch (OrmDataSet.getElem((SRM_ORM_Code)orm)._orm_template) {
                case ORMTCOD_SPHERE: 
                case ORMTCOD_OBLATE_ELLIPSOID: 
                case ORMTCOD_SPHERE_ORIGIN: 
                case ORMTCOD_OBLATE_ELLIPSOID_ORIGIN: {
                    break;
                }
                default: {
                    throw new SrmException(3, "SRF_TransverseMercator: Invalid ORM for SRF");
                }
            }
        }
        if (orm != SRM_ORM_Code.ORMCOD_ABSTRACT_3D && Const.isValidOrmRt(orm, rt)) {
            if (!(Const.isWellFormedLongitude(params.origin_longitude) && Const.isWellFormedLatitude(params.origin_latitude) && Const.isWellFormedScale(params.central_scale))) {
                throw new SrmException(3, new String("SRF_TransverseMercator: Invalid SRF parameters"));
            }
        } else {
            throw new SrmException(3, "SRF_TransverseMercator: Invalid ORM/RT pair");
        }
    }

    protected static void forLambertConformalConic(SRM_ORM_Code orm, SRM_RT_Code rt, SRF_LCC_Params params) throws SrmException {
        if (orm.toInt() > 0) {
            switch (OrmDataSet.getElem((SRM_ORM_Code)orm)._orm_template) {
                case ORMTCOD_SPHERE: 
                case ORMTCOD_OBLATE_ELLIPSOID: 
                case ORMTCOD_SPHERE_ORIGIN: 
                case ORMTCOD_OBLATE_ELLIPSOID_ORIGIN: {
                    break;
                }
                default: {
                    throw new SrmException(3, "SRF_LambertConformalConic: Invalid ORM for SRF");
                }
            }
        }
        if (orm != SRM_ORM_Code.ORMCOD_ABSTRACT_3D && Const.isValidOrmRt(orm, rt)) {
            if (params.latitude2 != 1234.4321 ? !Const.isWellFormedLongitude(params.origin_longitude) || !Const.isWellFormedLatitude(params.latitude1) || !Const.isWellFormedLatitude(params.latitude2) || params.latitude1 == -params.latitude2 : !Const.isWellFormedLongitude(params.origin_longitude) && (params.latitude1 <= 0.0 || params.latitude1 > 1.0)) {
                throw new SrmException(3, "SRF_LambertConformalConic: Invalid SRF parameters");
            }
        } else {
            throw new SrmException(3, "SRF_LambertConformalConic: Invalid ORM/RT pair");
        }
    }

    protected static void forPolarStereographic(SRM_ORM_Code orm, SRM_RT_Code rt, SRF_PS_Params params) throws SrmException {
        if (orm.toInt() > 0) {
            switch (OrmDataSet.getElem((SRM_ORM_Code)orm)._orm_template) {
                case ORMTCOD_SPHERE: 
                case ORMTCOD_OBLATE_ELLIPSOID: 
                case ORMTCOD_SPHERE_ORIGIN: 
                case ORMTCOD_OBLATE_ELLIPSOID_ORIGIN: {
                    break;
                }
                default: {
                    throw new SrmException(3, "SRF_PolarStereographic: Invalid ORM for SRF");
                }
            }
        }
        if (orm == SRM_ORM_Code.ORMCOD_ABSTRACT_3D || !Const.isValidOrmRt(orm, rt)) {
            throw new SrmException(3, "SRF_PolarStereographic: Invalid ORM/RT pair");
        }
        if (!Const.isWellFormedScale(params.central_scale)) {
            throw new SrmException(3, new String("SRF_PolarStereographic: Invalid central scale"));
        }
        if (params.polar_aspect != SRM_Polar_Aspect.PLRASP_NORTH && params.polar_aspect != SRM_Polar_Aspect.PLRASP_SOUTH) {
            throw new SrmException(3, new String("SRF_PolarStereographic: Invalid polar aspect"));
        }
    }

    protected static void forEquidistantCylindrical(SRM_ORM_Code orm, SRM_RT_Code rt, SRF_EC_Params params) throws SrmException {
        if (orm.toInt() > 0) {
            switch (OrmDataSet.getElem((SRM_ORM_Code)orm)._orm_template) {
                case ORMTCOD_SPHERE: 
                case ORMTCOD_OBLATE_ELLIPSOID: 
                case ORMTCOD_SPHERE_ORIGIN: 
                case ORMTCOD_OBLATE_ELLIPSOID_ORIGIN: {
                    break;
                }
                default: {
                    throw new SrmException(3, "SRF_EquidistantCylindrical: Invalid ORM for SRF");
                }
            }
        }
        if (orm != SRM_ORM_Code.ORMCOD_ABSTRACT_3D && Const.isValidOrmRt(orm, rt)) {
            if (!Const.isWellFormedLongitude(params.origin_longitude) || !Const.isWellFormedScale(params.central_scale)) {
                throw new SrmException(3, new String("SRF_EquidistantCylindrical: Invalid SRF parameters"));
            }
        } else {
            throw new SrmException(3, "SRF_EquidistantCylindrical: Invalid ORM/RT pair");
        }
    }

    protected static void forLocalSpaceRectangular2D(SRM_ORM_Code orm, SRM_RT_Code rt, SRF_LSR_2D_Params params) throws SrmException {
        if (orm != SRM_ORM_Code.ORMCOD_ABSTRACT_2D || !Const.isValidOrmRt(orm, rt)) {
            throw new SrmException(3, "SRF_LocalSpaceRectangular2D: Invalid ORM/RT pair");
        }
        Lsr2Conv.compute_F_u_v(params);
    }

    protected static void forLocalSpaceAzimuthal(SRM_ORM_Code orm, SRM_RT_Code rt) throws SrmException {
        if (orm != SRM_ORM_Code.ORMCOD_ABSTRACT_2D || !Const.isValidOrmRt(orm, rt)) {
            throw new SrmException(3, "SRF_LocalSpaceAzimuthal: Invalid ORM/RT pair");
        }
    }

    protected static void forLocalSpacePolar(SRM_ORM_Code orm, SRM_RT_Code rt) throws SrmException {
        if (orm != SRM_ORM_Code.ORMCOD_ABSTRACT_2D || !Const.isValidOrmRt(orm, rt)) {
            throw new SrmException(3, "SRF_LocalSpacePolar: Invalid ORM/RT pair");
        }
    }
}

