/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.business.audit.api;

import java.net.UnknownHostException;
import org.seedstack.business.audit.api.Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Initiator {
    private static final Logger LOG = LoggerFactory.getLogger(Initiator.class);
    private final String id;
    private final String name;
    private Address address;

    public Initiator(String id, String name, String ipAddress) {
        this.id = id;
        this.name = name;
        try {
            this.address = new Address(ipAddress);
        }
        catch (UnknownHostException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(e.getMessage(), (Throwable)e);
            }
            this.address = null;
            LOG.warn("Could not retrieve an IP address for connected user : {}", (Object)e.getMessage());
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Address getAddress() {
        return this.address;
    }
}

