/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.business.audit.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.ArrayUtils;
import org.seedstack.business.audit.api.TrailExceptionHandler;
import org.seedstack.business.audit.spi.TrailWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditConfigurer.class);
    private static final String TRAIL_WRITERS_KEY = "writers";
    private static final String TRAIL_EXCEPTION_HANDLERS_KEY = "exceptionHandlers";
    private Configuration configuration;
    private Map<Class<?>, Collection<Class<?>>> auditClasses;

    public AuditConfigurer(Configuration configuration, Map<Class<?>, Collection<Class<?>>> auditClasses) {
        this.configuration = configuration;
        this.auditClasses = auditClasses;
    }

    public Set<Class<? extends TrailWriter>> findTrailWriters() {
        String[] trailWriters = this.configuration.getStringArray(TRAIL_WRITERS_KEY);
        Collection<Class<?>> scannedTrailWriters = this.auditClasses.get(TrailWriter.class);
        if (trailWriters.length == 0) {
            LOGGER.info("No TrailWriter specified");
            return Collections.emptySet();
        }
        return this.findClasses(trailWriters, scannedTrailWriters, TrailWriter.class);
    }

    public Set<Class<? extends TrailExceptionHandler>> findTrailExceptionHandlers() {
        String[] trailExceptionHandlers = this.configuration.getStringArray(TRAIL_EXCEPTION_HANDLERS_KEY);
        Collection<Class<?>> scannedTrailExceptionHandlers = this.auditClasses.get(TrailExceptionHandler.class);
        if (trailExceptionHandlers.length == 0) {
            LOGGER.info("No audit TrailExceptionHandler specified, using every handler found");
            HashSet<Class<? extends TrailExceptionHandler>> foundExceptionHandlers = new HashSet<Class<? extends TrailExceptionHandler>>();
            for (Class<?> class1 : scannedTrailExceptionHandlers) {
                foundExceptionHandlers.add(class1);
                LOGGER.info("Registered audit exception handler {}", class1);
            }
            return foundExceptionHandlers;
        }
        return this.findClasses(trailExceptionHandlers, scannedTrailExceptionHandlers, TrailExceptionHandler.class);
    }

    private <E> Set<Class<? extends E>> findClasses(String[] configuration, Collection<Class<?>> scannedClasses, Class<? extends E> type) {
        HashSet foundClasses = new HashSet();
        for (Class<?> class1 : scannedClasses) {
            if (!ArrayUtils.contains((Object[])configuration, (Object)class1.getSimpleName()) && !ArrayUtils.contains((Object[])configuration, (Object)class1.getName())) continue;
            foundClasses.add(class1);
            LOGGER.info("Registered {} {}", (Object)type.getSimpleName(), class1);
        }
        if (foundClasses.isEmpty()) {
            LOGGER.warn("No {} as defined in the configuration could be found. Make sure the configuration match the name (or simple name) of the class", (Object)type.getSimpleName());
        }
        return foundClasses;
    }
}

