/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.business.audit.internal;

import java.util.Set;
import javax.el.ELContext;
import javax.inject.Inject;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang.StringUtils;
import org.jodah.typetools.TypeResolver;
import org.seedstack.business.audit.api.AuditService;
import org.seedstack.business.audit.api.Trail;
import org.seedstack.business.audit.api.TrailExceptionHandler;
import org.seedstack.business.audit.api.annotations.Audited;
import org.seedstack.business.audit.internal.AuditContext;
import org.seedstack.seed.el.api.ELContextBuilder;
import org.seedstack.seed.el.api.ELService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditedInterceptor
implements MethodInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(AuditedInterceptor.class);
    private static final ThreadLocal<AuditContext> THREAD_LOCAL = new ThreadLocal<AuditContext>(){

        @Override
        protected AuditContext initialValue() {
            return new AuditContext();
        }
    };
    @Inject
    private AuditService auditService;
    @Inject
    private Set<TrailExceptionHandler> exceptionHandlers;
    @Inject
    private ELService elService;
    @Inject
    private ELContextBuilder elContextBuilder;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Audited annotation = invocation.getMethod().getAnnotation(Audited.class);
        if (annotation == null) {
            return invocation.proceed();
        }
        AuditContext context = THREAD_LOCAL.get();
        Trail trail = context.getTrail();
        if (trail == null) {
            trail = this.auditService.createTrail();
            context.setTrail(trail);
        }
        ++context.nbNestedAudits;
        ELContextBuilder.ELPropertyProvider argsPropertyProvider = this.elContextBuilder.defaultContext().withProperty("args", (Object)invocation.getArguments());
        String messageBefore = annotation.messageBefore();
        if (!StringUtils.isEmpty((String)messageBefore)) {
            try {
                String evaluatedMessage = (String)this.elService.withExpression(messageBefore, String.class).withContext(argsPropertyProvider.build()).asValueExpression().eval();
                this.auditService.trail(evaluatedMessage, trail);
            }
            catch (Exception e) {
                LOG.error("Audit error (does not affect execution) : could not write before action", (Throwable)e);
            }
        }
        try {
            Object result = invocation.proceed();
            try {
                ELContext elContext = argsPropertyProvider.withProperty("result", result).build();
                String evaluatedMessage = this.elService.withExpression(annotation.messageAfter(), String.class).withContext(elContext).asValueExpression().eval().toString();
                this.auditService.trail(evaluatedMessage, trail);
            }
            catch (Exception e) {
                LOG.error("Audit error (does not affect execution) : could not write after action", (Throwable)e);
            }
            Object e = result;
            return e;
        }
        catch (Exception e) {
            try {
                if (!context.getAuditedExceptions().contains(e)) {
                    context.getAuditedExceptions().add(e);
                    ELContext elContext = argsPropertyProvider.withProperty("exception", (Object)e).build();
                    boolean handled = false;
                    for (TrailExceptionHandler handler : this.exceptionHandlers) {
                        Class handledException = TypeResolver.resolveRawArgument(TrailExceptionHandler.class, handler.getClass());
                        if (!handledException.isAssignableFrom(e.getClass())) continue;
                        handled = true;
                        String message = (String)this.elService.withExpression(handler.describeException(e), String.class).withContext(elContext).asValueExpression().eval();
                        this.auditService.trail(message, trail);
                    }
                    if (!handled) {
                        String message = !StringUtils.isEmpty((String)annotation.messageOnException()) ? annotation.messageOnException() : "Audited action threw an exception : " + e.getClass() + " : " + e.getMessage();
                        this.auditService.trail((String)this.elService.withExpression(message, String.class).withContext(elContext).asValueExpression().eval(), trail);
                    }
                }
            }
            catch (Exception auditException) {
                LOG.error("Audit error (does not affect execution) : could not write exception", (Throwable)auditException);
                throw e;
            }
            throw e;
        }
        finally {
            --context.nbNestedAudits;
            if (context.nbNestedAudits == 0) {
                THREAD_LOCAL.remove();
            }
        }
    }
}

