/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.business.audit.internal;

import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.seedstack.business.audit.api.AuditEvent;
import org.seedstack.business.audit.api.AuditService;
import org.seedstack.business.audit.api.Host;
import org.seedstack.business.audit.api.Initiator;
import org.seedstack.business.audit.api.Trail;
import org.seedstack.business.audit.spi.TrailWriter;
import org.seedstack.seed.core.api.Application;
import org.seedstack.seed.security.api.SecuritySupport;
import org.seedstack.seed.security.api.principals.SimplePrincipalProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuditService
implements AuditService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAuditService.class);
    private static Host host;
    private static AtomicLong trailIds;
    @Inject
    private Application application;
    @Inject
    private SecuritySupport securitySupport;
    @Inject
    private Set<TrailWriter> trailWriters;

    @Override
    public Trail createTrail() {
        return new Trail(trailIds.getAndIncrement(), this.createInitiator(), this.getHost());
    }

    @Override
    public void trail(String message, Trail trail) {
        AuditEvent auditEvent = new AuditEvent(message, trail);
        for (TrailWriter writer : this.trailWriters) {
            writer.writeEvent(auditEvent);
        }
    }

    private Initiator createInitiator() {
        Initiator initiator;
        if (this.securitySupport.isAuthenticated()) {
            SimplePrincipalProvider fullNamePrincipal = this.securitySupport.getSimplePrincipalByName("fullName");
            String fullName = fullNamePrincipal == null ? "" : fullNamePrincipal.getValue();
            initiator = new Initiator(this.securitySupport.getSimplePrincipalByName("userId").getValue(), fullName, this.securitySupport.getHost());
        } else {
            LOG.warn("An audited code is being run by an unauthenticated user");
            initiator = new Initiator("unknown user id", "unknow user name", this.securitySupport.getHost());
        }
        return initiator;
    }

    void initHost() {
        host = new Host(this.application.getId(), this.application.getName());
    }

    Host getHost() {
        if (host == null) {
            this.initHost();
        }
        return host;
    }

    static {
        trailIds = new AtomicLong(0L);
    }
}

