/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.business.audit.api;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.seedstack.business.audit.api.Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Host {
    private static final Logger LOG = LoggerFactory.getLogger(Host.class);
    private final String name;
    private final String id;
    private Address address;

    public Host(String id, String name, String hostName) {
        this.id = id;
        this.name = name;
        try {
            this.address = new Address(hostName);
        }
        catch (UnknownHostException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(e.getMessage(), (Throwable)e);
            }
            this.address = null;
            LOG.info("Could not find application server hostname : {}", (Object)e.getMessage());
        }
    }

    public Host(String id, String name) {
        this.id = id;
        this.name = name;
        try {
            this.address = new Address(InetAddress.getLocalHost());
        }
        catch (UnknownHostException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(e.getMessage(), (Throwable)e);
            }
            this.address = null;
            LOG.info("Could not find application server hostname : {}", (Object)e.getMessage());
        }
    }

    public String getName() {
        return this.name;
    }

    public Address getAddress() {
        return this.address;
    }

    public String getId() {
        return this.id;
    }
}

