/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.business.audit.internal;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.seedstack.business.audit.api.AuditService;
import org.seedstack.business.audit.api.TrailExceptionHandler;
import org.seedstack.business.audit.api.annotations.Audited;
import org.seedstack.business.audit.internal.AuditConfigurer;
import org.seedstack.business.audit.internal.AuditedInterceptor;
import org.seedstack.business.audit.internal.DefaultAuditService;
import org.seedstack.business.audit.spi.TrailWriter;

public class AuditModule
extends AbstractModule {
    private AuditConfigurer auditConfigurer;

    public AuditModule(AuditConfigurer auditConfigurer) {
        this.auditConfigurer = auditConfigurer;
    }

    protected void configure() {
        this.bind(AuditService.class).to(DefaultAuditService.class);
        Multibinder writers = Multibinder.newSetBinder((Binder)this.binder(), TrailWriter.class);
        Set<Class<? extends TrailWriter>> foundTrailWriters = this.auditConfigurer.findTrailWriters();
        for (Class<? extends TrailWriter> trailWriterClass : foundTrailWriters) {
            writers.addBinding().to(trailWriterClass);
        }
        Multibinder exHandlers = Multibinder.newSetBinder((Binder)this.binder(), TrailExceptionHandler.class);
        for (Class<? extends TrailExceptionHandler> exceptionHandlerClass : this.auditConfigurer.findTrailExceptionHandlers()) {
            exHandlers.addBinding().to(exceptionHandlerClass);
        }
        AuditedInterceptor interceptor = new AuditedInterceptor();
        this.requestInjection(interceptor);
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Audited.class), new MethodInterceptor[]{interceptor});
        InjectionListener<DefaultAuditService> injectionListener = new InjectionListener<DefaultAuditService>(){

            public void afterInjection(DefaultAuditService injectee) {
                injectee.initHost();
            }
        };
        TypeListener typeListener = new TypeListener((InjectionListener)injectionListener){
            final /* synthetic */ InjectionListener val$injectionListener;
            {
                this.val$injectionListener = injectionListener;
            }

            public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                encounter.register(this.val$injectionListener);
            }
        };
        this.bindListener((Matcher)new AbstractMatcher<TypeLiteral<?>>(){

            public boolean matches(TypeLiteral<?> typeLiteral) {
                return DefaultAuditService.class.isAssignableFrom(typeLiteral.getRawType());
            }
        }, typeListener);
    }
}

