/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.business.jpa.infrastructure.identity;

import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.seedstack.business.api.domain.Entity;
import org.seedstack.business.api.domain.base.BaseEntity;
import org.seedstack.business.api.domain.identity.IdentityErrorCodes;
import org.seedstack.business.api.domain.identity.SequenceHandler;
import org.seedstack.seed.core.api.ErrorCode;
import org.seedstack.seed.core.api.SeedException;

@Named(value="oracle-sequence")
public class OracleSequenceHandler
implements SequenceHandler<BaseEntity<Long>, Long> {
    @Inject
    private EntityManager entityManager;
    private static final String SEQUENCE_NAME = "identity.sequence-name";

    public Long handle(Entity entity, Configuration entityConfiguration) {
        Long convertedId;
        String sequence = entityConfiguration.getString(SEQUENCE_NAME);
        if (StringUtils.isBlank((String)sequence)) {
            SeedException.createNew((ErrorCode)IdentityErrorCodes.NO_SEQUENCE_NAME_FOUND_FOR_ENTITY).put("entityClass", entity.getClass()).thenThrows();
        }
        Object id = this.entityManager.createNativeQuery("SELECT " + sequence + ".NEXTVAL FROM DUAL").getSingleResult();
        try {
            LongConverter converter = new LongConverter();
            convertedId = (Long)converter.convert(Long.class, id);
        }
        catch (ConversionException e) {
            throw SeedException.wrap((Throwable)e, (ErrorCode)IdentityErrorCodes.ID_CAST_EXCEPTION).put("object", id).put("objectType", id.getClass()).put("entity", (Object)entity.getClass().getSimpleName());
        }
        return convertedId;
    }
}

