/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.business.jpa.infrastructure.repository;

import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.seedstack.business.api.domain.AggregateRoot;
import org.seedstack.business.core.domain.base.BaseRepository;

public abstract class BaseJpaRepository<A extends AggregateRoot<K>, K>
extends BaseRepository<A, K> {
    @Inject
    protected EntityManager entityManager;

    public BaseJpaRepository() {
    }

    protected BaseJpaRepository(Class<A> aggregateRootClass, Class<K> kClass) {
        super(aggregateRootClass, kClass);
    }

    protected A doLoad(K id) {
        return (A)((AggregateRoot)this.entityManager.find(this.getAggregateRootClass(), id));
    }

    @Deprecated
    protected void doDelete(K id) {
        this.entityManager.remove((Object)this.load(id));
    }

    protected void doDelete(A aggregate) {
        this.entityManager.remove(aggregate);
    }

    protected void doPersist(A aggregate) {
        this.entityManager.persist(aggregate);
    }

    protected A doSave(A aggregate) {
        return (A)((AggregateRoot)this.entityManager.merge(aggregate));
    }
}

