/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.business.jpa.assertions;

import org.apache.commons.collections.iterators.ArrayIterator;
import org.kametic.specifications.AbstractSpecification;
import org.kametic.specifications.Specification;
import org.seedstack.business.api.assertions.BusinessAssertionsErrorCodes;
import org.seedstack.business.api.assertions.BusinessReflectionAsserts;
import org.seedstack.business.api.specifications.BaseClassSpecifications;
import org.seedstack.business.core.domain.base.BaseFactory;
import org.seedstack.business.jpa.assertions.BusinessJpaAssertionsErrorCodes;
import org.seedstack.business.jpa.infrastructure.repository.BaseJpaRepository;
import org.seedstack.seed.core.api.ErrorCode;
import org.seedstack.seed.core.api.SeedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BusinessJpaReflectionAsserts {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusinessJpaReflectionAsserts.class);
    private static final String PARENT_CLASS_NAME = "parentClassName";
    private static final String MORE = "more";

    private BusinessJpaReflectionAsserts() {
    }

    public static void assertJpaRepositoryClassIsValid(Class<?> actual) {
        BusinessJpaReflectionAsserts.$(actual, BusinessJpaReflectionAsserts.parentInterfacesHasOneRepositoryInterface(), BusinessJpaAssertionsErrorCodes.CLASS_MUST_IMPLEMENT_A_REPOSITORY_INTERFACE, new String[0]);
        BusinessJpaReflectionAsserts.$(actual, BaseClassSpecifications.classInherits(BaseJpaRepository.class), (ErrorCode)BusinessAssertionsErrorCodes.CLASS_MUST_EXTENDS, PARENT_CLASS_NAME, BaseJpaRepository.class.getName(), MORE, "Please do not forget to remove all methods already defined.");
    }

    public static void assertDefaultFactoryClassIsValid(Class<?> actual) {
        BusinessJpaReflectionAsserts.$(actual, BusinessJpaReflectionAsserts.parentInterfacesHasOneFactoryInterface(), BusinessJpaAssertionsErrorCodes.CLASS_MUST_IMPLEMENT_A_FACTORY_INTERFACE, new String[0]);
        BusinessJpaReflectionAsserts.$(actual, BaseClassSpecifications.classInherits(BaseFactory.class), (ErrorCode)BusinessAssertionsErrorCodes.CLASS_MUST_EXTENDS, PARENT_CLASS_NAME, BaseFactory.class.getName(), MORE, "Please do not forget to remove all methods already defined.");
    }

    public static void assertDefaultDomainServiceClassIsValid(Class<?> actual) {
        BusinessJpaReflectionAsserts.$(actual, BusinessJpaReflectionAsserts.parentInterfacesHasOneDomainServiceInterface(), BusinessJpaAssertionsErrorCodes.CLASS_MUST_IMPLEMENT_A_DOMAIN_SERVICE_INTERFACE, new String[0]);
    }

    public static void assertDefaultApplicationServiceClassIsValid(Class<?> actual) {
        BusinessJpaReflectionAsserts.$(actual, BusinessJpaReflectionAsserts.parentInterfacesHasOneApplicationServiceInterface(), BusinessJpaAssertionsErrorCodes.CLASS_MUST_IMPLEMENT_A_APPLICATION_SERVICE_INTERFACE, new String[0]);
    }

    public static void assertDomainPolicyInternalClassIsValid(Class<?> actual) {
        BusinessJpaReflectionAsserts.$(actual, BusinessJpaReflectionAsserts.parentInterfacesHasOneDomainPolicyInterface(), BusinessJpaAssertionsErrorCodes.CLASS_MUST_IMPLEMENT_A_DOMAIN_POLICY_INTERFACE, new String[0]);
    }

    private static Specification<Class<?>> parentInterfacesHasOneRepositoryInterface() {
        return new AbstractSpecification<Class<?>>(){

            public boolean isSatisfiedBy(Class<?> candidate) {
                boolean oneInterfaceIsGenericRepo = false;
                for (Class<?> interfaceClass : candidate.getInterfaces()) {
                    try {
                        BusinessReflectionAsserts.assertRepositoryInterfaceClassIsValid(interfaceClass);
                        oneInterfaceIsGenericRepo = true;
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.debug(e.getMessage(), (Throwable)e);
                    }
                }
                return oneInterfaceIsGenericRepo;
            }
        };
    }

    private static Specification<Class<?>> parentInterfacesHasOneFactoryInterface() {
        return new AbstractSpecification<Class<?>>(){

            public boolean isSatisfiedBy(Class<?> candidate) {
                boolean oneInterfaceIsGenericRepo = false;
                for (Class<?> interfaceClass : candidate.getInterfaces()) {
                    try {
                        BusinessReflectionAsserts.assertFactoryInterfaceClassIsValid(interfaceClass);
                        oneInterfaceIsGenericRepo = true;
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.debug(e.getMessage(), (Throwable)e);
                    }
                }
                return oneInterfaceIsGenericRepo;
            }
        };
    }

    private static Specification<Class<?>> parentInterfacesHasOneDomainServiceInterface() {
        return new AbstractSpecification<Class<?>>(){

            public boolean isSatisfiedBy(Class<?> candidate) {
                boolean oneInterfaceIsGenericRepo = false;
                for (Class<?> interfaceClass : candidate.getInterfaces()) {
                    try {
                        BusinessReflectionAsserts.assertDomainServiceInterfaceClassIsValid(interfaceClass);
                        oneInterfaceIsGenericRepo = true;
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.debug(e.getMessage(), (Throwable)e);
                    }
                }
                return oneInterfaceIsGenericRepo;
            }
        };
    }

    private static Specification<Class<?>> parentInterfacesHasOneApplicationServiceInterface() {
        return new AbstractSpecification<Class<?>>(){

            public boolean isSatisfiedBy(Class<?> candidate) {
                boolean oneInterfaceIsGenericRepo = false;
                for (Class<?> interfaceClass : candidate.getInterfaces()) {
                    try {
                        BusinessReflectionAsserts.assertApplicationServiceInterfaceClassIsValid(interfaceClass);
                        oneInterfaceIsGenericRepo = true;
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.debug(e.getMessage(), (Throwable)e);
                    }
                }
                return oneInterfaceIsGenericRepo;
            }
        };
    }

    private static Specification<Class<?>> parentInterfacesHasOneDomainPolicyInterface() {
        return new AbstractSpecification<Class<?>>(){

            public boolean isSatisfiedBy(Class<?> candidate) {
                boolean oneInterfaceIsGenericRepo = false;
                for (Class<?> interfaceClass : candidate.getInterfaces()) {
                    try {
                        BusinessReflectionAsserts.assertDomainPolicyInterfaceClassIsValid(interfaceClass);
                        oneInterfaceIsGenericRepo = true;
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.debug(e.getMessage(), (Throwable)e);
                    }
                }
                return oneInterfaceIsGenericRepo;
            }
        };
    }

    private static <T> void $(T actual, Specification<T> specification, ErrorCode errorCode, String ... messages) {
        if (!specification.isSatisfiedBy(actual)) {
            SeedException seedException = SeedException.createNew((ErrorCode)errorCode);
            ArrayIterator it = new ArrayIterator((Object)messages);
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = "";
                if (it.hasNext()) {
                    value = (String)it.next();
                }
                seedException.put(key, (Object)value);
            }
            if (actual instanceof Class) {
                seedException.put("className", (Object)((Class)actual).getName());
            }
            throw seedException;
        }
    }
}

