/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.business.jpa;

import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import org.seedstack.business.api.domain.AggregateRoot;
import org.seedstack.business.api.domain.BaseRepository;

public abstract class BaseJpaRepository<A extends AggregateRoot<K>, K>
extends BaseRepository<A, K> {
    @Inject
    protected EntityManager entityManager;

    public BaseJpaRepository() {
    }

    protected BaseJpaRepository(Class<A> aggregateRootClass, Class<K> kClass) {
        super(aggregateRootClass, kClass);
    }

    protected A doLoad(K id) {
        return (A)((AggregateRoot)this.entityManager.find(this.getAggregateRootClass(), id));
    }

    protected void doDelete(K id) {
        AggregateRoot aggregate = this.load(id);
        if (aggregate == null) {
            throw new EntityNotFoundException("Attempt to delete non-existent aggregate with id " + id + " of class " + this.getAggregateRootClass().getCanonicalName());
        }
        this.entityManager.remove((Object)aggregate);
    }

    protected void doDelete(A aggregate) {
        this.entityManager.remove(aggregate);
    }

    protected void doPersist(A aggregate) {
        this.entityManager.persist(aggregate);
    }

    protected A doSave(A aggregate) {
        return (A)((AggregateRoot)this.entityManager.merge(aggregate));
    }
}

