/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.business.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.codemonkey.javareflection.FieldUtils;
import org.kametic.specifications.AbstractSpecification;
import org.kametic.specifications.AndSpecification;
import org.kametic.specifications.NotSpecification;
import org.kametic.specifications.OrSpecification;
import org.kametic.specifications.Specification;
import org.kametic.specifications.reflect.ClassMethodsAnnotatedWith;
import org.kametic.specifications.reflect.DescendantOfSpecification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseClassSpecifications {
    private static final Logger logger = LoggerFactory.getLogger(BaseClassSpecifications.class);

    public static Specification<Class<?>> classIs(final Class<?> attendee) {
        return new AbstractSpecification<Class<?>>(){

            public boolean isSatisfiedBy(Class<?> candidate) {
                return candidate != null && candidate.equals(attendee);
            }
        };
    }

    public static Specification<Class<?>> classAnnotatedWith(final Class<? extends Annotation> klass) {
        return new AbstractSpecification<Class<?>>(){

            public boolean isSatisfiedBy(Class<?> candidate) {
                return candidate != null && candidate.getAnnotation(klass) != null;
            }
        };
    }

    public static Specification<Class<?>> descendantOf(Class<?> ancestor) {
        return new DescendantOfSpecification(ancestor);
    }

    public static Specification<Class<?>> classModifierIs(final int modifier) {
        return new AbstractSpecification<Class<?>>(){

            public boolean isSatisfiedBy(Class<?> candidate) {
                return (candidate.getModifiers() & modifier) != 0;
            }
        };
    }

    public static Specification<Class<?>> classConstructorIsPublic() {
        return new AbstractSpecification<Class<?>>(){

            public boolean isSatisfiedBy(Class<?> candidate) {
                for (Constructor<?> constructor : candidate.getDeclaredConstructors()) {
                    if (!Modifier.isPublic(constructor.getModifiers())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Specification<Class<?>> classIsIn(final Collection<Class<?>> classes) {
        return new AbstractSpecification<Class<?>>(){

            public boolean isSatisfiedBy(Class<?> candidate) {
                return candidate != null && classes != null && classes.contains(candidate);
            }
        };
    }

    public static Specification<Class<?>> ancestorImplements(final Class<?> interfaceClass) {
        return new AbstractSpecification<Class<?>>(){

            public boolean isSatisfiedBy(Class<?> candidate) {
                Class<?>[] allInterfacesAndClasses;
                if (candidate == null) {
                    return false;
                }
                boolean result = false;
                block0: for (Class<?> clazz : allInterfacesAndClasses = BaseClassSpecifications.getAllInterfacesAndClasses(candidate)) {
                    if (clazz.isInterface()) continue;
                    for (Class<?> i : clazz.getInterfaces()) {
                        if (!i.equals(interfaceClass)) continue;
                        result = true;
                        continue block0;
                    }
                }
                return result;
            }
        };
    }

    public static Specification<Class<?>> fieldDeepAnnotatedWith(final Class<? extends Annotation> annotationClass) {
        return new AbstractSpecification<Class<?>>(){

            public boolean isSatisfiedBy(Class<?> candidate) {
                try {
                    if (candidate != null) {
                        do {
                            for (Field field : candidate.getDeclaredFields()) {
                                if (!field.isAnnotationPresent(annotationClass)) continue;
                                return true;
                            }
                        } while ((candidate = candidate.getSuperclass()) != null && candidate != Object.class);
                    }
                }
                catch (Throwable error) {
                    logger.trace(String.format("Warning in Specification fieldAnnotatedWith. Candidate: %s, annotation: %s", candidate.getSimpleName(), annotationClass.getSimpleName()), error);
                }
                return false;
            }
        };
    }

    public static Specification<Class<?>> classInherits(final Class<?> klass) {
        return new AbstractSpecification<Class<?>>(){

            public boolean isSatisfiedBy(Class<?> candidate) {
                return candidate != null && klass.isAssignableFrom(candidate);
            }
        };
    }

    public static Specification<Class<?>> ancestorMetaAnnotatedWith(final Class<? extends Annotation> anoKlass) {
        return new AbstractSpecification<Class<?>>(){

            public boolean isSatisfiedBy(Class<?> candidate) {
                Class<?>[] allInterfacesAndClasses;
                if (candidate == null) {
                    return false;
                }
                boolean result = false;
                for (Class<?> clazz : allInterfacesAndClasses = BaseClassSpecifications.getAllInterfacesAndClasses(candidate)) {
                    boolean satisfiedBy = BaseClassSpecifications.classMetaAnnotatedWith(anoKlass).isSatisfiedBy(clazz);
                    if (!satisfiedBy) continue;
                    result = true;
                    break;
                }
                return result;
            }
        };
    }

    public static Specification<Class<?>> classMetaAnnotatedWith(final Class<? extends Annotation> klass) {
        return new AbstractSpecification<Class<?>>(){

            public boolean isSatisfiedBy(Class<?> candidate) {
                return candidate != null && BaseClassSpecifications.hasAnnotationDeep(candidate, klass);
            }
        };
    }

    public static Specification<Class<?>> classHasSetters() {
        return new AbstractSpecification<Class<?>>(){

            public boolean isSatisfiedBy(Class<?> candidate) {
                return candidate != null && ((List)FieldUtils.collectFields(candidate, candidate, EnumSet.of(FieldUtils.Visibility.PUBLIC, FieldUtils.Visibility.PROTECTED, FieldUtils.Visibility.PRIVATE, FieldUtils.Visibility.DEFAULT), EnumSet.of(FieldUtils.BeanRestriction.YES_SETTER)).get(candidate)).isEmpty();
            }
        };
    }

    public static Specification<Class<?>> classHasOnlyPackageViewSetters() {
        return new AbstractSpecification<Class<?>>(){

            public boolean isSatisfiedBy(Class<?> candidate) {
                return candidate != null && ((List)FieldUtils.collectFields(candidate, candidate, EnumSet.of(FieldUtils.Visibility.DEFAULT), EnumSet.of(FieldUtils.BeanRestriction.YES_SETTER)).get(candidate)).isEmpty() && BaseClassSpecifications.classHasSetters().isSatisfiedBy(candidate);
            }
        };
    }

    public static boolean hasAnnotationDeep(Class<?> aClass, Class<? extends Annotation> annotationClass) {
        if (aClass.equals(annotationClass)) {
            return true;
        }
        for (Annotation anno : aClass.getAnnotations()) {
            Class<? extends Annotation> annoClass = anno.annotationType();
            if (annoClass.getPackage().getName().startsWith("java.lang") || !BaseClassSpecifications.hasAnnotationDeep(annoClass, annotationClass)) continue;
            return true;
        }
        return false;
    }

    public static Specification<Class<?>> classIsInterface() {
        return new AbstractSpecification<Class<?>>(){

            public boolean isSatisfiedBy(Class<?> candidate) {
                return candidate != null && candidate.isInterface();
            }
        };
    }

    public static Specification<Class<?>> classIsNot(final Class<?> notCandidate) {
        return new AbstractSpecification<Class<?>>(){

            public boolean isSatisfiedBy(Class<?> candidate) {
                return candidate != null && !candidate.equals(notCandidate);
            }
        };
    }

    public static Specification<Class<?>> classHasSuperInterfaces() {
        return new AbstractSpecification<Class<?>>(){

            public boolean isSatisfiedBy(Class<?> candidate) {
                Class[] interfaces = new Class[]{};
                if (candidate != null) {
                    interfaces = candidate.getInterfaces();
                }
                return candidate != null && interfaces != null && interfaces.length > 0;
            }
        };
    }

    public static Specification<Class<?>> classIsAnnotation() {
        return new AbstractSpecification<Class<?>>(){

            public boolean isSatisfiedBy(Class<?> candidate) {
                return candidate != null && candidate.isAnnotation();
            }
        };
    }

    public static Specification<Class<?>> classIsAbstract() {
        return new AbstractSpecification<Class<?>>(){

            public boolean isSatisfiedBy(Class<?> candidate) {
                return candidate != null && Modifier.isAbstract(candidate.getModifiers());
            }
        };
    }

    public static Specification<Class<?>> methodAnnotatedWith(Class<? extends Annotation> annotationClass) {
        return new ClassMethodsAnnotatedWith(annotationClass);
    }

    static Class<?>[] getAllInterfacesAndClasses(Class<?> clazz) {
        return BaseClassSpecifications.getAllInterfacesAndClasses(new Class[]{clazz});
    }

    static Class<?>[] getAllInterfacesAndClasses(Class<?>[] classes) {
        if (0 == classes.length) {
            return classes;
        }
        ArrayList<Class> extendedClasses = new ArrayList<Class>();
        for (Class<?> clazz : classes) {
            Class<?> superclass;
            if (clazz == null) continue;
            Class<?>[] interfaces = clazz.getInterfaces();
            if (interfaces != null) {
                extendedClasses.addAll(Arrays.asList(interfaces));
            }
            if ((superclass = clazz.getSuperclass()) == null || superclass == Object.class) continue;
            extendedClasses.addAll(Arrays.asList(superclass));
        }
        return (Class[])ArrayUtils.addAll((Object[])classes, (Object[])BaseClassSpecifications.getAllInterfacesAndClasses(extendedClasses.toArray(new Class[extendedClasses.size()])));
    }

    public static Specification<Class<?>> or(Specification<Class<?>> ... participants) {
        return new OrSpecification(participants);
    }

    public static Specification<Class<?>> and(Specification<Class<?>> ... participants) {
        return new AndSpecification(participants);
    }

    public static Specification<Class<?>> not(Specification<Class<?>> participant) {
        return new NotSpecification(participant);
    }
}

