/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.business.api;

import com.google.common.collect.Lists;
import com.google.inject.util.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.fest.reflect.core.Reflection;
import org.javatuples.Decade;
import org.javatuples.Ennead;
import org.javatuples.Octet;
import org.javatuples.Pair;
import org.javatuples.Quartet;
import org.javatuples.Quintet;
import org.javatuples.Septet;
import org.javatuples.Sextet;
import org.javatuples.Triplet;
import org.javatuples.Tuple;
import org.javatuples.Unit;
import org.seedstack.seed.core.utils.SeedCheckUtils;

public final class Tuples {
    private Tuples() {
    }

    public static <TUPLE extends Tuple> TUPLE create(List<?> objects) {
        SeedCheckUtils.checkIf((objects.size() <= 10 ? 1 : 0) != 0, (String[])new String[]{"Can't create a Tuple of more than ten element."});
        Class<? extends Tuple> tupleClass = Tuples.classOfTuple(objects.toArray(new Object[objects.size()]));
        return (TUPLE)((Tuple)Reflection.staticMethod((String)"fromCollection").withReturnType(tupleClass).withParameterTypes(new Class[]{Collection.class}).in(tupleClass).invoke(new Object[]{objects}));
    }

    public static <TUPLE extends Tuple> TUPLE create(Object firstObject, Object ... objects) {
        ArrayList list = Lists.newArrayList((Object[])new Object[]{firstObject});
        list.addAll(Arrays.asList(objects));
        return Tuples.create(list);
    }

    @Deprecated
    public static <TUPLE extends Tuple> TUPLE createTupleFromList(Object ... objects) {
        return Tuples.create(objects, new Object[0]);
    }

    @Deprecated
    public static <TUPLE extends Tuple> TUPLE createTupleFromList(List<Object> objects) {
        return Tuples.create(objects);
    }

    public static Class<? extends Tuple> classOfTuple(List<?> objects) {
        return Tuples.classOfTuple(objects.toArray());
    }

    public static Class<? extends Tuple> classOfTuple(Object ... objects) {
        Class<Unit> tupleClass = null;
        int tupleSize = objects.length;
        switch (tupleSize) {
            case 1: {
                tupleClass = Unit.class;
                break;
            }
            case 2: {
                tupleClass = Pair.class;
                break;
            }
            case 3: {
                tupleClass = Triplet.class;
                break;
            }
            case 4: {
                tupleClass = Quartet.class;
                break;
            }
            case 5: {
                tupleClass = Quintet.class;
                break;
            }
            case 6: {
                tupleClass = Sextet.class;
                break;
            }
            case 7: {
                tupleClass = Septet.class;
                break;
            }
            case 8: {
                tupleClass = Octet.class;
                break;
            }
            case 9: {
                tupleClass = Ennead.class;
                break;
            }
            case 10: {
                tupleClass = Decade.class;
                break;
            }
        }
        return tupleClass;
    }

    public static ParameterizedType typeOfTuple(Class<?> ... classes) {
        return Types.newParameterizedType(Tuples.classOfTuple(classes), (Type[])classes);
    }

    public static <T> List<T> toList(Tuple tuple) {
        ArrayList objects = new ArrayList(tuple.getSize());
        for (Object o : tuple) {
            objects.add(o);
        }
        return objects;
    }

    public static List<?> toListOfClasses(Tuple tuple) {
        ArrayList objects = new ArrayList(tuple.getSize());
        for (Object o : tuple) {
            objects.add(o.getClass());
        }
        return objects;
    }
}

