/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.business.api.interfaces.view;

import java.util.List;
import org.seedstack.business.api.interfaces.finder.Result;
import org.seedstack.business.api.interfaces.view.View;
import org.seedstack.business.api.interfaces.view.VirtualList;

public abstract class AbstractView<Item>
implements View<Item> {
    private static final long serialVersionUID = 5881361314603724860L;
    protected final VirtualList<Item> resultList;
    protected final long resultSize;
    protected final long resultViewOffset;
    protected final long resultViewSize;

    public AbstractView(VirtualList<Item> items, long resultViewOffset, long resultViewSize) {
        this.resultList = items;
        this.resultSize = items.size();
        this.resultViewOffset = resultViewOffset;
        this.resultViewSize = resultViewOffset + resultViewSize > this.resultSize ? this.resultSize - resultViewOffset : resultViewSize;
    }

    public AbstractView(Result<Item> result, long resultViewOffset, long resultViewSize) {
        this(new VirtualList<Item>(result.getResult(), result.getOffset(), result.getFullSize()), resultViewOffset, resultViewSize);
    }

    public AbstractView(List<Item> list, long resultViewOffset, long resultViewSize) {
        this(new VirtualList<Item>(list, 0L, list.size()), resultViewOffset, resultViewSize);
    }

    public AbstractView(List<Item> items, long subListStart, long subListSize, long resultViewOffset, long resultViewSize) {
        this(new VirtualList<Item>(items, subListStart, subListSize), resultViewOffset, resultViewSize);
    }

    @Override
    public List<Item> getView() {
        return this.resultList.subList(this.resultViewOffset, this.resultViewOffset + this.resultViewSize);
    }

    public long getResultSize() {
        return this.resultSize;
    }
}

