/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.business.api.interfaces.view;

import java.util.ArrayList;
import java.util.List;

class VirtualList<T> {
    private List<T> subList;
    private long subListOffset;
    private long fullListSize;

    public VirtualList(List<T> subList, long subListOffset, long fullListSize) {
        this.subList = subList;
        this.subListOffset = subListOffset;
        this.fullListSize = fullListSize;
    }

    public T get(long index) {
        this.checkRange(index);
        if (this.checkSubRange(index)) {
            return this.subList.get((int)(index - this.subListOffset));
        }
        return null;
    }

    public List<T> subList(long from, long to) {
        if (this.fullListSize > 0L && to - from > 0L) {
            this.checkRange(from);
            this.checkRange(to - 1L);
            this.assertSubRange(from, to - 1L);
            return this.subList.subList((int)(from - this.subListOffset), (int)(to - this.subListOffset));
        }
        return new ArrayList();
    }

    public long size() {
        return this.fullListSize;
    }

    private void checkRange(long index) {
        if (index < 0L || index >= this.fullListSize) {
            throw new IllegalStateException("Out of range access to virtual list: " + index);
        }
    }

    private boolean checkSubRange(long index) {
        return this.subListOffset <= index && index < this.subListOffset + (long)this.subList.size();
    }

    private void assertSubRange(long from, long to) {
        if (!this.checkSubRange(from) || !this.checkSubRange(to)) {
            throw new IndexOutOfBoundsException("Required data for the sub list [" + from + "," + (to + 1L) + "[ have not been loaded in the virtual list.");
        }
    }
}

