/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.business.domain;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.seedstack.business.domain.DomainErrorCodes;
import org.seedstack.business.domain.Entity;
import org.seedstack.seed.ErrorCode;
import org.seedstack.seed.SeedException;

public abstract class BaseEntity<ID>
implements Entity<ID> {
    @Override
    public abstract ID getEntityId();

    @Override
    public final int hashCode() {
        return this.checkIdentity().hashCode();
    }

    @Override
    public final boolean equals(Object o) {
        ID entityId = this.checkIdentity();
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return entityId.equals(((BaseEntity)this.getClass().cast(o)).getEntityId());
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.DEFAULT_STYLE, (boolean)false);
    }

    private ID checkIdentity() {
        ID entityId = this.getEntityId();
        if (entityId == null) {
            throw SeedException.createNew((ErrorCode)DomainErrorCodes.ENTITY_WITHOUT_IDENTITY_ISSUE).put("className", (Object)this.getClass().getName());
        }
        return entityId;
    }
}

