/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.business.domain;

import java.lang.reflect.Type;
import net.jodah.typetools.TypeResolver;
import org.seedstack.business.domain.AggregateRoot;
import org.seedstack.business.domain.Delete;
import org.seedstack.business.domain.Persist;
import org.seedstack.business.domain.Read;
import org.seedstack.business.domain.Repository;
import org.seedstack.seed.core.utils.SeedReflectionUtils;

public abstract class BaseRepository<AGGREGATE extends AggregateRoot<KEY>, KEY>
implements Repository<AGGREGATE, KEY> {
    private static final int AGGREGATE_INDEX = 0;
    private static final int KEY_INDEX = 1;
    protected Class<AGGREGATE> aggregateRootClass;
    protected Class<KEY> keyClass;

    protected BaseRepository() {
        this.aggregateRootClass = this.init(0);
        this.keyClass = this.init(1);
    }

    protected BaseRepository(Class<AGGREGATE> aggregateRootClass, Class<KEY> keyClass) {
        this.aggregateRootClass = aggregateRootClass;
        this.keyClass = keyClass;
    }

    private <T> Class<T> init(int index) {
        Class class1 = SeedReflectionUtils.cleanProxy(this.getClass());
        return TypeResolver.resolveRawArguments((Type)class1.getGenericSuperclass(), (Class)class1)[index];
    }

    @Override
    public Class<AGGREGATE> getAggregateRootClass() {
        return this.aggregateRootClass;
    }

    @Override
    public Class<KEY> getKeyClass() {
        return this.keyClass;
    }

    @Override
    public final AGGREGATE load(KEY id) {
        return this.doLoad(id);
    }

    @Override
    public final void delete(KEY id) {
        this.doDelete((AGGREGATE)id);
    }

    @Override
    public final void delete(AGGREGATE aggregate) {
        this.doDelete(aggregate);
    }

    @Override
    public final void persist(AGGREGATE aggregate) {
        this.doPersist(aggregate);
    }

    @Override
    public final AGGREGATE save(AGGREGATE aggregate) {
        return this.doSave(aggregate);
    }

    @Read
    protected abstract AGGREGATE doLoad(KEY var1);

    @Delete
    protected abstract void doDelete(KEY var1);

    @Delete
    protected abstract void doDelete(AGGREGATE var1);

    @Persist
    protected abstract void doPersist(AGGREGATE var1);

    @Persist
    protected abstract AGGREGATE doSave(AGGREGATE var1);
}

