/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.business.domain;

import org.seedstack.business.domain.DomainErrorCodes;
import org.seedstack.business.domain.Entity;
import org.seedstack.seed.ErrorCode;
import org.seedstack.seed.SeedException;

public abstract class BaseEntity<ID>
implements Entity<ID> {
    @Override
    public abstract ID getEntityId();

    @Override
    public int hashCode() {
        return this.getIdentity().hashCode();
    }

    @Override
    public boolean equals(Object other) {
        ID entityId = this.getIdentity();
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return entityId.equals(((BaseEntity)this.getClass().cast(other)).getEntityId());
    }

    @Override
    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.getEntityId());
    }

    private ID getIdentity() {
        ID entityId = this.getEntityId();
        if (entityId == null) {
            throw SeedException.createNew((ErrorCode)DomainErrorCodes.ENTITY_WITHOUT_IDENTITY_ISSUE).put("className", (Object)this.getClass().getName());
        }
        return entityId;
    }
}

