/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.business.view;

import java.util.List;
import org.seedstack.business.finder.Result;
import org.seedstack.business.view.AbstractView;
import org.seedstack.business.view.Page;

public class PaginatedView<Item>
extends AbstractView<Item> {
    private final long pageIndex;
    private final long pagesCount;

    public PaginatedView(List<Item> items, long pageSize, long pageIndex) {
        super(items, pageIndex * pageSize, pageSize);
        this.pageIndex = pageIndex;
        this.pagesCount = this.countPages(pageSize, this.resultSize);
    }

    public PaginatedView(Result<Item> result, long pageSize, long pageIndex) {
        super(result, pageIndex * pageSize, pageSize);
        this.pageIndex = pageIndex;
        this.pagesCount = this.countPages(pageSize, this.resultSize);
    }

    public PaginatedView(Result<Item> result, Page page) {
        this(result, page.getCapacity(), page.getIndex());
    }

    public PaginatedView(List<Item> subList, long subListStart, long realListSize, long pageSize, long pageIndex) {
        super(subList, subListStart, realListSize, pageIndex * pageSize, pageSize);
        this.pageIndex = pageIndex;
        this.pagesCount = this.countPages(pageSize, this.resultSize);
    }

    private long countPages(long pageSize, long totalItems) {
        if (pageSize == 0L) {
            throw new IllegalArgumentException("View cannot be computed with a page size of 0");
        }
        return (long)Math.ceil((double)totalItems / (double)pageSize);
    }

    public boolean hasNext() {
        return this.pageIndex + 1L < this.pagesCount;
    }

    public Page next() {
        if (this.hasNext()) {
            return new Page(this.pageIndex + 1L, this.resultViewSize);
        }
        return null;
    }

    public boolean hasPrev() {
        return this.pageIndex > 0L;
    }

    public Page prev() {
        if (this.hasPrev()) {
            return new Page(this.pageIndex - 1L, this.resultViewSize);
        }
        return null;
    }

    public long getPageSize() {
        return this.resultViewSize;
    }

    public long getPageIndex() {
        return this.pageIndex;
    }

    public long getPagesCount() {
        return this.pagesCount;
    }
}

