/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.business.domain;

import java.util.Optional;
import java.util.stream.Stream;
import org.seedstack.business.domain.AggregateExistsException;
import org.seedstack.business.domain.AggregateNotFoundException;
import org.seedstack.business.domain.AggregateRoot;
import org.seedstack.business.domain.DomainRepository;
import org.seedstack.business.specification.IdentitySpecification;
import org.seedstack.business.specification.Specification;
import org.seedstack.business.specification.dsl.SpecificationBuilder;

@DomainRepository
public interface Repository<A extends AggregateRoot<I>, I> {
    public void add(A var1) throws AggregateExistsException;

    public Stream<A> get(Specification<A> var1, Option ... var2);

    default public Optional<A> get(I id) {
        return this.get(new IdentitySpecification(id), new Option[0]).findFirst();
    }

    default public boolean contains(Specification<A> specification) {
        return this.count(specification) > 0L;
    }

    default public boolean contains(I id) {
        return this.contains((A)new IdentitySpecification(id));
    }

    default public boolean contains(A aggregate) {
        return this.contains((A)aggregate.getId());
    }

    default public long count(Specification<A> specification) {
        return this.get(specification, new Option[0]).count();
    }

    default public long size() {
        return this.count(Specification.any());
    }

    default public boolean isEmpty() {
        return this.size() == 0L;
    }

    public long remove(Specification<A> var1) throws AggregateNotFoundException;

    default public void remove(I id) throws AggregateNotFoundException {
        long removedCount = this.remove(new IdentitySpecification(id));
        if (removedCount == 0L) {
            throw new AggregateNotFoundException("Non-existent aggregate " + this.getAggregateRootClass().getSimpleName() + " identified with " + id + " cannot be removed");
        }
        if (removedCount > 1L) {
            throw new IllegalStateException("More than one aggregate " + this.getAggregateRootClass().getSimpleName() + " identified with " + id + " have been removed");
        }
    }

    default public void remove(A aggregate) throws AggregateNotFoundException {
        this.remove((A)aggregate.getId());
    }

    default public A update(A aggregate) throws AggregateNotFoundException {
        this.remove(aggregate);
        this.add(aggregate);
        return aggregate;
    }

    default public A addOrUpdate(A aggregate) {
        if (!this.contains((A)aggregate.getId())) {
            this.add(aggregate);
            return aggregate;
        }
        return this.update(aggregate);
    }

    default public void clear() {
        this.remove(Specification.any());
    }

    public Class<A> getAggregateRootClass();

    public Class<I> getIdentifierClass();

    public SpecificationBuilder getSpecificationBuilder();

    public static interface Option {
    }
}

