/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.business.specification;

import java.util.Objects;
import org.seedstack.business.domain.AggregateRoot;
import org.seedstack.business.specification.Specification;

public class IdentitySpecification<A extends AggregateRoot<I>, I>
implements Specification<A> {
    private final I expectedIdentifier;

    public IdentitySpecification(I expectedIdentifier) {
        Objects.requireNonNull(expectedIdentifier, "Expected identifier cannot be null");
        this.expectedIdentifier = expectedIdentifier;
    }

    @Override
    public boolean isSatisfiedBy(A candidate) {
        return this.expectedIdentifier.equals(candidate.getId());
    }

    public String toString() {
        return String.valueOf(this.expectedIdentifier);
    }

    public I getExpectedIdentifier() {
        return this.expectedIdentifier;
    }
}

