/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.business.specification;

import org.seedstack.business.specification.NotSpecification;
import org.seedstack.business.specification.Specification;

public class OrSpecification<T>
implements Specification<T> {
    private final Specification<? super T>[] specifications;

    @SafeVarargs
    public OrSpecification(Specification<? super T> ... specifications) {
        this.specifications = (Specification[])specifications.clone();
    }

    @Override
    public boolean isSatisfiedBy(T candidate) {
        for (Specification<T> specification : this.specifications) {
            if (!specification.isSatisfiedBy(candidate)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.specifications.length; ++i) {
            Specification<T> term = this.specifications[i];
            boolean isNegation = term instanceof NotSpecification;
            if (!isNegation) {
                sb.append("(");
            }
            sb.append(term.toString());
            if (!isNegation) {
                sb.append(")");
            }
            if (i >= this.specifications.length - 1) continue;
            sb.append(" \u2228 ");
        }
        return sb.toString();
    }

    public Specification<? super T>[] getSpecifications() {
        return (Specification[])this.specifications.clone();
    }
}

