/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.business.specification;

import java.util.Objects;
import java.util.function.Predicate;
import org.seedstack.business.specification.AndSpecification;
import org.seedstack.business.specification.FalseSpecification;
import org.seedstack.business.specification.NotSpecification;
import org.seedstack.business.specification.OrSpecification;
import org.seedstack.business.specification.TrueSpecification;

@FunctionalInterface
public interface Specification<T> {
    public static <T> Specification<T> any() {
        return new TrueSpecification();
    }

    public static <T> Specification<T> none() {
        return new FalseSpecification();
    }

    default public Specification<T> and(Specification<? super T> other) {
        Objects.requireNonNull(other);
        return new AndSpecification(this, other);
    }

    default public Specification<T> negate() {
        return new NotSpecification(this);
    }

    default public Specification<T> or(Specification<? super T> other) {
        Objects.requireNonNull(other);
        return new OrSpecification(this, other);
    }

    default public Predicate<T> asPredicate() {
        return this::isSatisfiedBy;
    }

    public boolean isSatisfiedBy(T var1);
}

