/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.business.internal;

import com.google.inject.Injector;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.seedstack.business.api.Event;
import org.seedstack.business.api.EventFixture;
import org.seedstack.business.api.EventHandler;
import org.seedstack.business.api.EventProvider;
import org.seedstack.business.api.EventService;
import org.seedstack.business.api.EventServiceProvider;
import org.seedstack.business.api.EventTestErrorCodes;
import org.seedstack.business.api.HandlerProvider;
import org.seedstack.business.api.ServiceProvider;
import org.seedstack.business.internal.ContextLink;
import org.seedstack.seed.core.api.ErrorCode;
import org.seedstack.seed.core.api.SeedException;

class EventFixtureInternal
implements EventFixture {
    static final String EVENT = "event";
    static final String EXPECTED = "expected";
    static final String HANDLERS = "handlers";
    static final String HANDLER = "handler";
    @Inject
    private Injector injector;
    @Inject
    private ContextLink contextLink;
    @Inject
    private EventService eventService;

    EventFixtureInternal() {
    }

    @Override
    public EventProvider given(Event event) {
        return new EventProviderInternal(event);
    }

    @Override
    public ServiceProvider given(Class aClass) {
        return new ServiceProviderInternal(aClass);
    }

    class ServiceProviderInternal
    implements ServiceProvider,
    HandlerProvider {
        private List<Class> argClasses;
        private final Class underTest;
        private String method;
        private Object[] args;

        ServiceProviderInternal(Class underTest) {
            this.underTest = underTest;
        }

        @Override
        public HandlerProvider whenCalled(String method, Object ... args) {
            this.method = method;
            this.args = args;
            this.argClasses = new ArrayList<Class>(args.length);
            for (Object arg : args) {
                this.argClasses.add(arg.getClass());
            }
            return this;
        }

        @Override
        public void eventWasHandledBy(Event event, Class<? extends EventHandler> handler) {
            HashMap<Class<? extends EventHandler>, Event> handlerMap = new HashMap<Class<? extends EventHandler>, Event>();
            handlerMap.put(handler, event);
            this.eventWasHandledBy(handlerMap);
        }

        @Override
        public void eventWasHandledBy(Map<Class<? extends EventHandler>, Event> handlerMap) {
            try {
                Method declaredMethod = this.underTest.getDeclaredMethod(this.method, this.argClasses.toArray(new Class[this.args.length]));
                Object instance = EventFixtureInternal.this.injector.getInstance(this.underTest);
                declaredMethod.invoke(instance, this.args);
            }
            catch (Exception e) {
                throw SeedException.wrap((Throwable)e, (ErrorCode)EventTestErrorCodes.FAILED_TO_INVOKE_METHOD);
            }
            Map<Class<? extends EventHandler>, Event> callMap = EventFixtureInternal.this.contextLink.peek();
            for (Map.Entry<Class<? extends EventHandler>, Event> entry : handlerMap.entrySet()) {
                Event event = callMap.get(entry.getKey());
                if (event == null) {
                    throw SeedException.createNew((ErrorCode)EventTestErrorCodes.HANDLER_WAS_NOT_CALLED).put(EventFixtureInternal.HANDLER, entry.getKey());
                }
                if (entry.getValue() != null && entry.getValue().equals(event)) continue;
                throw SeedException.createNew((ErrorCode)EventTestErrorCodes.HANDLER_WAS_NOT_CALLED_WITH_EXPECTED_EVENT).put(EventFixtureInternal.HANDLER, entry.getKey()).put(EventFixtureInternal.EVENT, (Object)entry.getValue());
            }
        }
    }

    class EventProviderInternal
    implements EventProvider,
    EventServiceProvider {
        private final Event event;

        EventProviderInternal(Event event) {
            this.event = event;
        }

        @Override
        public EventServiceProvider whenFired() {
            EventFixtureInternal.this.eventService.fire(this.event);
            return this;
        }

        @Override
        public void wasHandledBy(Class<? extends EventHandler> ... handlers) {
            Set<Class<? extends EventHandler>> calledHandlers = EventFixtureInternal.this.contextLink.peek().keySet();
            for (Class<? extends EventHandler> handler : handlers) {
                if (calledHandlers.contains(handler)) continue;
                throw SeedException.createNew((ErrorCode)EventTestErrorCodes.EVENT_WAS_NOT_HANDLER_BY).put(EventFixtureInternal.EVENT, (Object)this.event).put(EventFixtureInternal.HANDLER, handler);
            }
        }

        @Override
        public void wasHandledExactlyBy(Class<? extends EventHandler> ... handlers) {
            Set<Class<? extends EventHandler>> calledHandlers = EventFixtureInternal.this.contextLink.peek().keySet();
            for (Class<? extends EventHandler> handler : handlers) {
                if (calledHandlers.contains(handler)) continue;
                throw SeedException.createNew((ErrorCode)EventTestErrorCodes.EVENT_WAS_NOT_EXACTLY_HANDLER_BY).put(EventFixtureInternal.EVENT, (Object)this.event).put(EventFixtureInternal.EXPECTED, handlers).put(EventFixtureInternal.HANDLERS, calledHandlers);
            }
            if (handlers.length != calledHandlers.size()) {
                throw SeedException.createNew((ErrorCode)EventTestErrorCodes.EVENT_WAS_NOT_EXACTLY_HANDLER_BY).put(EventFixtureInternal.EVENT, (Object)this.event).put(EventFixtureInternal.EXPECTED, handlers).put(EventFixtureInternal.HANDLERS, calledHandlers);
            }
        }

        @Override
        public void wasNotHandledBy(Class<? extends EventHandler> ... handlers) {
            Set<Class<? extends EventHandler>> calledHandlers = EventFixtureInternal.this.contextLink.peek().keySet();
            for (Class<? extends EventHandler> handler : handlers) {
                if (!calledHandlers.contains(handler)) continue;
                throw SeedException.createNew((ErrorCode)EventTestErrorCodes.EVENT_WAS_HANDLER_BY).put(EventFixtureInternal.EVENT, (Object)this.event).put(EventFixtureInternal.HANDLERS, calledHandlers).put(EventFixtureInternal.EXPECTED, handlers);
            }
        }
    }
}

