/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.business.internal;

import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.seedstack.business.api.EventFixture;
import org.seedstack.business.api.EventHandler;
import org.seedstack.business.internal.ContextLink;
import org.seedstack.business.internal.EventFixtureInternal;
import org.seedstack.business.internal.EventHandlerInterceptor;
import org.seedstack.seed.core.api.Install;

@Install
class EventTestModule
extends AbstractModule {
    EventTestModule() {
    }

    protected void configure() {
        this.bind(EventFixture.class).to(EventFixtureInternal.class);
        this.bind(ContextLink.class).in(Scopes.SINGLETON);
        EventHandlerInterceptor interceptor = new EventHandlerInterceptor();
        this.requestInjection(interceptor);
        this.bindInterceptor(Matchers.subclassesOf(EventHandler.class), this.handlerMethod(), new MethodInterceptor[]{interceptor});
    }

    Matcher<Method> handlerMethod() {
        return new AbstractMatcher<Method>(){

            public boolean matches(Method candidate) {
                return "handle".equals(candidate.getName()) && !candidate.isSynthetic();
            }
        };
    }
}

