/*
 * Decompiled with CFR 0.152.
 */
package org.selenide.selenoid;

import com.codeborne.selenide.Clipboard;
import com.codeborne.selenide.DefaultClipboard;
import com.codeborne.selenide.Driver;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.selenide.selenoid.SelenoidClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class SelenoidClipboard
implements Clipboard {
    private static final Logger log = LoggerFactory.getLogger(SelenoidClipboard.class);
    private final Driver driver;

    SelenoidClipboard(Driver driver) {
        this.driver = driver;
    }

    @Nonnull
    @CheckReturnValue
    public Driver driver() {
        return this.driver;
    }

    @Nonnull
    @CheckReturnValue
    public Clipboard object() {
        return this;
    }

    @CheckReturnValue
    @Nonnull
    public String getText() {
        if (this.driver.config().remote() == null) {
            log.debug("Working in local browser. Switching to a default Clipboard implementation.");
            return new DefaultClipboard(this.driver).getText();
        }
        return new SelenoidClient(this.driver.config().remote(), this.driver.getSessionId().toString()).getClipboardText();
    }

    public void setText(String text) {
        if (this.driver.config().remote() == null) {
            log.debug("Working in local browser. Switching to a default Clipboard implementation.");
            new DefaultClipboard(this.driver).setText(text);
        } else {
            new SelenoidClient(this.driver.config().remote(), this.driver.getSessionId().toString()).setClipboardText(text);
        }
    }
}

