/*
 * Decompiled with CFR 0.152.
 */
package org.selenide.selenoid;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.files.DownloadAction;
import com.codeborne.selenide.files.DownloadedFile;
import com.codeborne.selenide.files.FileFilter;
import com.codeborne.selenide.impl.DownloadFileToFolder;
import com.codeborne.selenide.impl.Downloader;
import com.codeborne.selenide.impl.FileHelper;
import com.codeborne.selenide.impl.WebElementSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;
import org.selenide.selenoid.SelenoidClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class DownloadFileInSelenoid
extends DownloadFileToFolder {
    private static final Logger log = LoggerFactory.getLogger(DownloadFileInSelenoid.class);
    private final Downloader downloader;

    public DownloadFileInSelenoid() {
        this(new Downloader());
    }

    DownloadFileInSelenoid(Downloader downloader) {
        this.downloader = downloader;
    }

    @CheckReturnValue
    @Nonnull
    public File download(WebElementSource anyClickableElement, WebElement clickable, long timeout, FileFilter fileFilter, DownloadAction action) throws FileNotFoundException {
        Driver driver = anyClickableElement.driver();
        Config config = driver.config();
        if (config.remote() == null) {
            log.debug("Working in local browser. Switching to a default FOLDER implementation.");
            return super.download(anyClickableElement, clickable, timeout, fileFilter, action);
        }
        SelenoidClient selenoidClient = new SelenoidClient(config.remote(), driver.getSessionId().toString());
        selenoidClient.deleteDownloadedFiles();
        clickable.click();
        Optional<String> downloadedFileName = this.waitForDownloads(selenoidClient, config, timeout, fileFilter);
        if (!downloadedFileName.isPresent()) {
            throw new FileNotFoundException("Failed to download file " + anyClickableElement + " in " + timeout + " ms.");
        }
        File downloadedFile = selenoidClient.download(downloadedFileName.get());
        return this.archiveFile(driver.config(), downloadedFile);
    }

    @CheckReturnValue
    @Nonnull
    private Optional<String> waitForDownloads(SelenoidClient selenoidClient, Config config, long timeout, FileFilter fileFilter) {
        Selenide.sleep((long)config.pollingInterval());
        List<String> fileNames = Collections.emptyList();
        Optional<String> matchingFile = Optional.empty();
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start <= timeout && !(matchingFile = this.firstMatchingFile(fileNames = selenoidClient.downloads(), fileFilter)).isPresent()) {
            Selenide.sleep((long)config.pollingInterval());
        }
        log.debug("All downloaded files: {}", fileNames);
        return matchingFile;
    }

    private Optional<String> firstMatchingFile(List<String> fileNames, FileFilter fileFilter) {
        return fileNames.stream().filter(fileName -> fileFilter.match(new DownloadedFile(new File((String)fileName), Collections.emptyMap()))).findFirst();
    }

    @CheckReturnValue
    @Nonnull
    private File archiveFile(Config config, File downloadedFile) {
        File uniqueFolder = this.downloader.prepareTargetFolder(config);
        File archivedFile = new File(uniqueFolder, downloadedFile.getName());
        FileHelper.moveFile((File)downloadedFile, (File)archivedFile);
        return archivedFile;
    }
}

