/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.geography;

import java.util.Objects;
import java.util.StringTokenizer;
import org.sellcom.geotemporal.geography.GeoRegionException;
import org.sellcom.geotemporal.geography.GeoRegionParseException;
import org.sellcom.geotemporal.geography.GeoRegionUtils;
import org.sellcom.geotemporal.internal.Contract;
import org.sellcom.geotemporal.internal.StringUtils;

public class GeoRegion {
    public static final GeoRegion ROOT = new GeoRegion("");
    private static GeoRegion defaultGeoRegion;
    private final String countryCode;
    private final String level1SubdivisionCode;
    private final String level2SubdivisionCode;
    private final String level3SubdivisionCode;
    private final String level4SubdivisionCode;
    private final String level5SubdivisionCode;

    public GeoRegion(String countryCode) {
        this(countryCode, "", "", "", "", "");
    }

    public GeoRegion(String countryCode, String level1SubdivisionCode) {
        this(countryCode, level1SubdivisionCode, "", "", "", "");
    }

    public GeoRegion(String countryCode, String level1SubdivisionCode, String level2SubdivisionCode) {
        this(countryCode, level1SubdivisionCode, level2SubdivisionCode, "", "", "");
    }

    public GeoRegion(String countryCode, String level1SubdivisionCode, String level2SubdivisionCode, String level3SubdivisionCode) {
        this(countryCode, level1SubdivisionCode, level2SubdivisionCode, level3SubdivisionCode, "", "");
    }

    public GeoRegion(String countryCode, String level1SubdivisionCode, String level2SubdivisionCode, String level3SubdivisionCode, String level4SubdivisionCode) {
        this(countryCode, level1SubdivisionCode, level2SubdivisionCode, level3SubdivisionCode, level4SubdivisionCode, "");
    }

    public GeoRegion(String countryCode, String level1SubdivisionCode, String level2SubdivisionCode, String level3SubdivisionCode, String level4SubdivisionCode, String level5SubdivisionCode) {
        Contract.checkArgument(countryCode != null, "Country code must not be null", new Object[0]);
        Contract.checkArgument(level1SubdivisionCode != null, "Subdivision code at level 1 must not be null", new Object[0]);
        Contract.checkArgument(level2SubdivisionCode != null, "Subdivision code at level 2 must not be null", new Object[0]);
        Contract.checkArgument(level3SubdivisionCode != null, "Subdivision code at level 3 must not be null", new Object[0]);
        Contract.checkArgument(level4SubdivisionCode != null, "Subdivision code at level 4 must not be null", new Object[0]);
        Contract.checkArgument(level5SubdivisionCode != null, "Subdivision code at level 5 must not be null", new Object[0]);
        this.countryCode = countryCode;
        this.level1SubdivisionCode = level1SubdivisionCode;
        this.level2SubdivisionCode = level2SubdivisionCode;
        this.level3SubdivisionCode = level3SubdivisionCode;
        this.level4SubdivisionCode = level4SubdivisionCode;
        this.level5SubdivisionCode = level5SubdivisionCode;
    }

    public GeoRegion atLevel(int level) {
        Contract.checkArgument(level >= 0, "Level must not be negative: {0}", level);
        switch (level) {
            case 0: {
                return new GeoRegion(this.countryCode);
            }
            case 1: {
                return new GeoRegion(this.countryCode, this.level1SubdivisionCode);
            }
            case 2: {
                return new GeoRegion(this.countryCode, this.level1SubdivisionCode, this.level2SubdivisionCode);
            }
            case 3: {
                return new GeoRegion(this.countryCode, this.level1SubdivisionCode, this.level2SubdivisionCode, this.level3SubdivisionCode);
            }
            case 4: {
                return new GeoRegion(this.countryCode, this.level1SubdivisionCode, this.level2SubdivisionCode, this.level3SubdivisionCode, this.level4SubdivisionCode);
            }
            case 5: {
                return new GeoRegion(this.countryCode, this.level1SubdivisionCode, this.level2SubdivisionCode, this.level3SubdivisionCode, this.level4SubdivisionCode, this.level5SubdivisionCode);
            }
        }
        throw new IllegalArgumentException(String.format("Invalid level: %d", level));
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof GeoRegion) {
            GeoRegion otherCast = (GeoRegion)other;
            return Objects.equals(this.countryCode, otherCast.countryCode) && Objects.equals(this.level1SubdivisionCode, otherCast.level1SubdivisionCode) && Objects.equals(this.level2SubdivisionCode, otherCast.level2SubdivisionCode) && Objects.equals(this.level3SubdivisionCode, otherCast.level3SubdivisionCode) && Objects.equals(this.level4SubdivisionCode, otherCast.level4SubdivisionCode) && Objects.equals(this.level5SubdivisionCode, otherCast.level5SubdivisionCode);
        }
        return false;
    }

    public String getCode() {
        if (!this.level5SubdivisionCode.isEmpty()) {
            return String.join((CharSequence)",", this.countryCode, this.level1SubdivisionCode, this.level2SubdivisionCode, this.level3SubdivisionCode, this.level4SubdivisionCode, this.level5SubdivisionCode);
        }
        if (!this.level4SubdivisionCode.isEmpty()) {
            return String.join((CharSequence)",", this.countryCode, this.level1SubdivisionCode, this.level2SubdivisionCode, this.level3SubdivisionCode, this.level4SubdivisionCode);
        }
        if (!this.level3SubdivisionCode.isEmpty()) {
            return String.join((CharSequence)",", this.countryCode, this.level1SubdivisionCode, this.level2SubdivisionCode, this.level3SubdivisionCode);
        }
        if (!this.level2SubdivisionCode.isEmpty()) {
            return String.join((CharSequence)",", this.countryCode, this.level1SubdivisionCode, this.level2SubdivisionCode);
        }
        if (!this.level1SubdivisionCode.isEmpty()) {
            return String.join((CharSequence)",", this.countryCode, this.level1SubdivisionCode);
        }
        return this.countryCode;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public static GeoRegion getDefault() {
        return defaultGeoRegion;
    }

    public GeoRegion getParent() {
        if (!StringUtils.isNullOrEmpty(this.level5SubdivisionCode)) {
            return new GeoRegion(this.countryCode, this.level1SubdivisionCode, this.level2SubdivisionCode, this.level3SubdivisionCode, this.level4SubdivisionCode);
        }
        if (!StringUtils.isNullOrEmpty(this.level4SubdivisionCode)) {
            return new GeoRegion(this.countryCode, this.level1SubdivisionCode, this.level2SubdivisionCode, this.level3SubdivisionCode);
        }
        if (!StringUtils.isNullOrEmpty(this.level3SubdivisionCode)) {
            return new GeoRegion(this.countryCode, this.level1SubdivisionCode, this.level2SubdivisionCode);
        }
        if (!StringUtils.isNullOrEmpty(this.level2SubdivisionCode)) {
            return new GeoRegion(this.countryCode, this.level1SubdivisionCode);
        }
        if (!StringUtils.isNullOrEmpty(this.level1SubdivisionCode)) {
            return new GeoRegion(this.countryCode);
        }
        return ROOT;
    }

    public int hashCode() {
        return Objects.hash(this.countryCode, this.level1SubdivisionCode, this.level2SubdivisionCode, this.level3SubdivisionCode, this.level4SubdivisionCode, this.level5SubdivisionCode);
    }

    public static GeoRegion parse(String code) {
        Contract.checkArgument(code != null, "Region code must not be null", new Object[0]);
        StringTokenizer tokenizer = new StringTokenizer(code, ",");
        switch (tokenizer.countTokens()) {
            case 1: {
                return new GeoRegion(tokenizer.nextToken());
            }
            case 2: {
                return new GeoRegion(tokenizer.nextToken(), tokenizer.nextToken());
            }
            case 3: {
                return new GeoRegion(tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken());
            }
            case 4: {
                return new GeoRegion(tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken());
            }
            case 5: {
                return new GeoRegion(tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken());
            }
            case 6: {
                return new GeoRegion(tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken());
            }
        }
        throw new GeoRegionParseException(String.format("Invalid code: %s", code));
    }

    public static void setDefault(GeoRegion region) {
        Contract.checkArgument(region != null, "Region must not be null", new Object[0]);
        defaultGeoRegion = region;
    }

    public String toString() {
        return this.getCode();
    }

    private static void initDefault() {
        String regionCode = System.getProperty("user.georegion");
        if (!StringUtils.isNullOrEmpty(regionCode)) {
            defaultGeoRegion = GeoRegion.parse(regionCode);
            return;
        }
        regionCode = GeoRegionUtils.regionCodeFromCountry();
        if (!StringUtils.isNullOrEmpty(regionCode)) {
            defaultGeoRegion = GeoRegion.parse(regionCode);
            return;
        }
        regionCode = GeoRegionUtils.regionCodeFromLanguage();
        if (!StringUtils.isNullOrEmpty(regionCode)) {
            defaultGeoRegion = GeoRegion.parse(regionCode);
            return;
        }
        throw new GeoRegionException("Cannot determine default GeoRegion. Please set the 'user.georegion' system property.");
    }

    static {
        GeoRegion.initDefault();
    }
}

