/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.geography;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

class GeoRegionUtils {
    private static final Map<String, String> countryCodes;
    private static final Map<String, String> languageCodes;

    private GeoRegionUtils() {
    }

    static String regionCodeFromCountry() {
        Locale defaultLocale = Locale.getDefault();
        String countryCode = defaultLocale.getCountry();
        if (countryCode.matches("[a-zA-Z]{2}")) {
            return countryCode.toUpperCase(Locale.ROOT);
        }
        if (countryCode.matches("[0-9]{3}")) {
            return countryCodes.get(countryCode);
        }
        return null;
    }

    static String regionCodeFromLanguage() {
        Locale defaultLocale = Locale.getDefault();
        String languageCode = defaultLocale.getLanguage();
        if (languageCode.matches("[a-zA-Z]{2}")) {
            return languageCodes.get(languageCode);
        }
        if (languageCode.matches("[a-zA-Z]{3}")) {
            return languageCodes.get(languageCode);
        }
        return null;
    }

    static {
        HashMap<String, String> codes = new HashMap<String, String>();
        codes.put("004", "AF");
        codes.put("008", "AL");
        codes.put("010", "AQ");
        codes.put("012", "DZ");
        codes.put("016", "AS");
        codes.put("020", "AD");
        codes.put("024", "AO");
        codes.put("028", "AG");
        codes.put("031", "AZ");
        codes.put("032", "AR");
        codes.put("036", "AU");
        codes.put("040", "AT");
        codes.put("044", "BS");
        codes.put("048", "BH");
        codes.put("050", "BD");
        codes.put("051", "AM");
        codes.put("052", "BB");
        codes.put("056", "BE");
        codes.put("060", "BM");
        codes.put("064", "BT");
        codes.put("068", "BO");
        codes.put("070", "BA");
        codes.put("072", "BW");
        codes.put("074", "BV");
        codes.put("076", "BR");
        codes.put("084", "BZ");
        codes.put("086", "IO");
        codes.put("090", "SB");
        codes.put("092", "VG");
        codes.put("096", "BN");
        codes.put("100", "BG");
        codes.put("104", "MM");
        codes.put("108", "BI");
        codes.put("112", "BY");
        codes.put("116", "KH");
        codes.put("120", "CM");
        codes.put("124", "CA");
        codes.put("132", "CV");
        codes.put("136", "KY");
        codes.put("140", "CF");
        codes.put("144", "LK");
        codes.put("148", "TD");
        codes.put("152", "CL");
        codes.put("156", "CN");
        codes.put("158", "TW");
        codes.put("162", "CX");
        codes.put("166", "CC");
        codes.put("170", "CO");
        codes.put("174", "KM");
        codes.put("175", "YT");
        codes.put("178", "CG");
        codes.put("180", "CD");
        codes.put("184", "CK");
        codes.put("188", "CR");
        codes.put("191", "HR");
        codes.put("192", "CU");
        codes.put("196", "CY");
        codes.put("203", "CZ");
        codes.put("204", "BJ");
        codes.put("208", "DK");
        codes.put("212", "DM");
        codes.put("214", "DO");
        codes.put("218", "EC");
        codes.put("222", "SV");
        codes.put("226", "GQ");
        codes.put("231", "ET");
        codes.put("232", "ER");
        codes.put("233", "EE");
        codes.put("234", "FO");
        codes.put("238", "FK");
        codes.put("239", "GS");
        codes.put("242", "FJ");
        codes.put("246", "FI");
        codes.put("248", "AX");
        codes.put("250", "FR");
        codes.put("254", "GF");
        codes.put("258", "PF");
        codes.put("260", "TF");
        codes.put("262", "DJ");
        codes.put("266", "GA");
        codes.put("268", "GE");
        codes.put("270", "GM");
        codes.put("275", "PS");
        codes.put("276", "DE");
        codes.put("288", "GH");
        codes.put("292", "GI");
        codes.put("296", "KI");
        codes.put("300", "GR");
        codes.put("304", "GL");
        codes.put("308", "GD");
        codes.put("312", "GP");
        codes.put("316", "GU");
        codes.put("320", "GT");
        codes.put("324", "GN");
        codes.put("328", "GY");
        codes.put("332", "HT");
        codes.put("334", "HM");
        codes.put("336", "VA");
        codes.put("340", "HN");
        codes.put("344", "HK");
        codes.put("348", "HU");
        codes.put("352", "IS");
        codes.put("356", "IN");
        codes.put("360", "ID");
        codes.put("364", "IR");
        codes.put("368", "IQ");
        codes.put("372", "IE");
        codes.put("376", "IL");
        codes.put("380", "IT");
        codes.put("384", "CI");
        codes.put("388", "JM");
        codes.put("392", "JP");
        codes.put("398", "KZ");
        codes.put("400", "JO");
        codes.put("404", "KE");
        codes.put("408", "KP");
        codes.put("410", "KR");
        codes.put("414", "KW");
        codes.put("417", "KG");
        codes.put("418", "LA");
        codes.put("422", "LB");
        codes.put("426", "LS");
        codes.put("428", "LV");
        codes.put("430", "LR");
        codes.put("434", "LY");
        codes.put("438", "LI");
        codes.put("440", "LT");
        codes.put("442", "LU");
        codes.put("446", "MO");
        codes.put("450", "MG");
        codes.put("454", "MW");
        codes.put("458", "MY");
        codes.put("462", "MV");
        codes.put("466", "ML");
        codes.put("470", "MT");
        codes.put("474", "MQ");
        codes.put("478", "MR");
        codes.put("480", "MU");
        codes.put("484", "MX");
        codes.put("492", "MC");
        codes.put("496", "MN");
        codes.put("498", "MD");
        codes.put("499", "ME");
        codes.put("500", "MS");
        codes.put("504", "MA");
        codes.put("508", "MZ");
        codes.put("512", "OM");
        codes.put("516", "NA");
        codes.put("520", "NR");
        codes.put("524", "NP");
        codes.put("528", "NL");
        codes.put("531", "CW");
        codes.put("533", "AW");
        codes.put("534", "SX");
        codes.put("535", "BQ");
        codes.put("540", "NC");
        codes.put("548", "VU");
        codes.put("554", "NZ");
        codes.put("558", "NI");
        codes.put("562", "NE");
        codes.put("566", "NG");
        codes.put("570", "NU");
        codes.put("574", "NF");
        codes.put("578", "NO");
        codes.put("580", "MP");
        codes.put("581", "UM");
        codes.put("583", "FM");
        codes.put("584", "MH");
        codes.put("585", "PW");
        codes.put("586", "PK");
        codes.put("591", "PA");
        codes.put("598", "PG");
        codes.put("600", "PY");
        codes.put("604", "PE");
        codes.put("608", "PH");
        codes.put("612", "PN");
        codes.put("616", "PL");
        codes.put("620", "PT");
        codes.put("624", "GW");
        codes.put("626", "TL");
        codes.put("630", "PR");
        codes.put("634", "QA");
        codes.put("638", "RE");
        codes.put("642", "RO");
        codes.put("643", "RU");
        codes.put("646", "RW");
        codes.put("652", "BL");
        codes.put("654", "SH");
        codes.put("659", "KN");
        codes.put("660", "AI");
        codes.put("662", "LC");
        codes.put("663", "MF");
        codes.put("666", "PM");
        codes.put("670", "VC");
        codes.put("674", "SM");
        codes.put("678", "ST");
        codes.put("682", "SA");
        codes.put("686", "SN");
        codes.put("688", "RS");
        codes.put("690", "SC");
        codes.put("694", "SL");
        codes.put("702", "SG");
        codes.put("703", "SK");
        codes.put("704", "VN");
        codes.put("705", "SI");
        codes.put("706", "SO");
        codes.put("710", "ZA");
        codes.put("716", "ZW");
        codes.put("724", "ES");
        codes.put("728", "SS");
        codes.put("729", "SD");
        codes.put("732", "EH");
        codes.put("740", "SR");
        codes.put("744", "SJ");
        codes.put("748", "SZ");
        codes.put("752", "SE");
        codes.put("756", "CH");
        codes.put("760", "SY");
        codes.put("762", "TJ");
        codes.put("764", "TH");
        codes.put("768", "TG");
        codes.put("772", "TK");
        codes.put("776", "TO");
        codes.put("780", "TT");
        codes.put("784", "AE");
        codes.put("788", "TN");
        codes.put("792", "TR");
        codes.put("795", "TM");
        codes.put("796", "TC");
        codes.put("798", "TV");
        codes.put("800", "UG");
        codes.put("804", "UA");
        codes.put("807", "MK");
        codes.put("818", "EG");
        codes.put("826", "GB");
        codes.put("831", "GG");
        codes.put("832", "JE");
        codes.put("833", "IM");
        codes.put("834", "TZ");
        codes.put("840", "US");
        codes.put("850", "VI");
        codes.put("854", "BF");
        codes.put("858", "UY");
        codes.put("860", "UZ");
        codes.put("862", "VE");
        codes.put("876", "WF");
        codes.put("882", "WS");
        codes.put("887", "YE");
        codes.put("894", "ZM");
        countryCodes = Collections.unmodifiableMap(codes);
        codes = new HashMap();
        codes.put("aa", "ET");
        codes.put("ab", "GE,02");
        codes.put("af", "ZA");
        codes.put("ak", "GH");
        codes.put("am", "ET");
        codes.put("an", "ES,02");
        codes.put("as", "IN");
        codes.put("av", "RU,05");
        codes.put("ay", "BO");
        codes.put("az", "AZ");
        codes.put("ba", "RU,02");
        codes.put("be", "BY");
        codes.put("bg", "BG");
        codes.put("bi", "VU");
        codes.put("bm", "ML");
        codes.put("bn", "BD");
        codes.put("bo", "CN,54");
        codes.put("br", "FR,53");
        codes.put("bs", "BA");
        codes.put("ca", "ES,07");
        codes.put("ce", "RU,20");
        codes.put("ch", "GU");
        codes.put("co", "FR,94");
        codes.put("cr", "CA,61");
        codes.put("cs", "CZ");
        codes.put("cv", "RU,21");
        codes.put("cy", "GB,W");
        codes.put("da", "DK");
        codes.put("de", "DE");
        codes.put("dv", "MV");
        codes.put("dz", "BT");
        codes.put("ee", "GH");
        codes.put("el", "GR");
        codes.put("en", "GB");
        codes.put("es", "ES");
        codes.put("et", "EE");
        codes.put("eu", "ES,14");
        codes.put("fa", "IR");
        codes.put("ff", "SN");
        codes.put("fi", "FI");
        codes.put("fj", "FJ");
        codes.put("fo", "FO");
        codes.put("fr", "FR");
        codes.put("fy", "NL,21");
        codes.put("ga", "IE");
        codes.put("gd", "GB,S");
        codes.put("gl", "ES,10");
        codes.put("gn", "PY");
        codes.put("gu", "IN");
        codes.put("gv", "IM");
        codes.put("ha", "NG");
        codes.put("he", "IL");
        codes.put("hi", "IN");
        codes.put("ho", "PG");
        codes.put("hr", "HR");
        codes.put("ht", "HT");
        codes.put("hu", "HU");
        codes.put("hy", "AM");
        codes.put("hz", "NA");
        codes.put("id", "ID");
        codes.put("ig", "NG");
        codes.put("ii", "CN");
        codes.put("ik", "US,02");
        codes.put("is", "IS");
        codes.put("it", "IT");
        codes.put("iu", "CA");
        codes.put("ja", "JP");
        codes.put("jv", "ID");
        codes.put("ka", "GE");
        codes.put("kg", "CD");
        codes.put("ki", "KE");
        codes.put("kj", "AO");
        codes.put("kk", "KZ");
        codes.put("kl", "GL");
        codes.put("km", "KH");
        codes.put("kn", "IN");
        codes.put("ko", "KR");
        codes.put("kr", "NG");
        codes.put("ks", "IN");
        codes.put("ku", "IQ,01");
        codes.put("kv", "RU,11");
        codes.put("kw", "GB,E,12000009,,06000052");
        codes.put("ky", "KG");
        codes.put("lb", "LU");
        codes.put("lg", "UG");
        codes.put("li", "NL,31");
        codes.put("ln", "CD");
        codes.put("lo", "LA");
        codes.put("lt", "LT");
        codes.put("lu", "CD");
        codes.put("lv", "LV");
        codes.put("mg", "MG");
        codes.put("mh", "MH");
        codes.put("mi", "NZ");
        codes.put("mk", "MK");
        codes.put("ml", "IN");
        codes.put("mn", "MN");
        codes.put("mr", "IN");
        codes.put("ms", "MY");
        codes.put("mt", "MT");
        codes.put("my", "MM");
        codes.put("na", "NR");
        codes.put("nb", "NO");
        codes.put("nd", "ZW");
        codes.put("ne", "NP");
        codes.put("ng", "NA");
        codes.put("nl", "NL");
        codes.put("nn", "NO");
        codes.put("no", "NO");
        codes.put("nr", "ZA");
        codes.put("nv", "US");
        codes.put("ny", "MW");
        codes.put("oc", "ES,07");
        codes.put("oj", "CA");
        codes.put("om", "ET");
        codes.put("or", "IN");
        codes.put("os", "RU,15");
        codes.put("pa", "IN");
        codes.put("pl", "PL");
        codes.put("ps", "PK");
        codes.put("pt", "PT");
        codes.put("qu", "PE");
        codes.put("rm", "CH,18");
        codes.put("rn", "BI");
        codes.put("ro", "RO");
        codes.put("ru", "RU");
        codes.put("rw", "RW");
        codes.put("sa", "IN");
        codes.put("sc", "IT,20");
        codes.put("sd", "PK");
        codes.put("se", "NO");
        codes.put("sg", "CF");
        codes.put("si", "LK");
        codes.put("sk", "SK");
        codes.put("sl", "SI");
        codes.put("sm", "WS");
        codes.put("sn", "ZW");
        codes.put("so", "SO");
        codes.put("sq", "AL");
        codes.put("sr", "RS");
        codes.put("ss", "SZ");
        codes.put("st", "LS");
        codes.put("su", "ID");
        codes.put("sv", "SE");
        codes.put("sw", "TZ");
        codes.put("ta", "IN");
        codes.put("te", "IN");
        codes.put("tg", "TJ");
        codes.put("th", "TH");
        codes.put("ti", "ET");
        codes.put("tk", "TM");
        codes.put("tl", "PH");
        codes.put("tn", "BW");
        codes.put("to", "TO");
        codes.put("tr", "TR");
        codes.put("ts", "ZA");
        codes.put("tt", "RU,16");
        codes.put("tw", "GH");
        codes.put("ty", "PF");
        codes.put("ug", "CN");
        codes.put("uk", "UA");
        codes.put("ur", "PK");
        codes.put("uz", "UZ");
        codes.put("ve", "ZA");
        codes.put("vi", "VN");
        codes.put("wa", "BE,03");
        codes.put("wo", "SN");
        codes.put("xh", "ZA");
        codes.put("yi", "IL");
        codes.put("yo", "NG");
        codes.put("za", "CN");
        codes.put("zh", "CN");
        codes.put("zu", "ZA");
        codes.put("aar", "ET");
        codes.put("abk", "GE,02");
        codes.put("ace", "ID");
        codes.put("ach", "UG");
        codes.put("ada", "GH");
        codes.put("ady", "RU,01");
        codes.put("afr", "ZA");
        codes.put("ain", "JP");
        codes.put("aka", "GH");
        codes.put("ale", "US,02");
        codes.put("alt", "RU,04");
        codes.put("amh", "ET");
        codes.put("anp", "IN");
        codes.put("arg", "ES,02");
        codes.put("arn", "CL");
        codes.put("arp", "US,56");
        codes.put("arw", "SR");
        codes.put("asm", "IN");
        codes.put("ast", "ES,03");
        codes.put("ava", "RU,05");
        codes.put("awa", "IN");
        codes.put("aym", "BO");
        codes.put("aze", "AZ");
        codes.put("bak", "RU,02");
        codes.put("bal", "PK");
        codes.put("bam", "ML");
        codes.put("ban", "ID");
        codes.put("bas", "CM");
        codes.put("bej", "SD");
        codes.put("bel", "BY");
        codes.put("bem", "ZM");
        codes.put("ben", "BD");
        codes.put("bho", "IN");
        codes.put("bik", "PH");
        codes.put("bin", "NG");
        codes.put("bis", "VU");
        codes.put("bla", "CA,48");
        codes.put("bod", "CN,54");
        codes.put("bos", "BA");
        codes.put("bra", "IN");
        codes.put("bre", "FR,53");
        codes.put("bua", "RU,03");
        codes.put("bug", "ID");
        codes.put("bul", "BG");
        codes.put("byn", "ER");
        codes.put("cad", "US,40");
        codes.put("car", "VE");
        codes.put("cat", "ES,07");
        codes.put("ceb", "PH");
        codes.put("ces", "CZ");
        codes.put("cha", "GU");
        codes.put("che", "RU,20");
        codes.put("chk", "FM");
        codes.put("chm", "RU,12");
        codes.put("chn", "CA,59");
        codes.put("cho", "US,40");
        codes.put("chp", "CA");
        codes.put("chr", "US,40");
        codes.put("chv", "RU,21");
        codes.put("chy", "US,30");
        codes.put("cor", "GB,E,12000009,,06000052");
        codes.put("cos", "FR,94");
        codes.put("cre", "CA,61");
        codes.put("crh", "UA,01");
        codes.put("csb", "PL,22");
        codes.put("cym", "GB,W");
        codes.put("dak", "US");
        codes.put("dan", "DK");
        codes.put("dar", "RU,05");
        codes.put("del", "US,10");
        codes.put("den", "CA,61");
        codes.put("deu", "DE");
        codes.put("dgr", "CA,61");
        codes.put("din", "SS");
        codes.put("div", "MV");
        codes.put("doi", "IN");
        codes.put("dsb", "DE,12");
        codes.put("dua", "CM");
        codes.put("dyu", "CI");
        codes.put("dzo", "BT");
        codes.put("efi", "NG");
        codes.put("eka", "NG");
        codes.put("ell", "GR");
        codes.put("eng", "GB");
        codes.put("est", "EE");
        codes.put("eus", "ES,14");
        codes.put("ewe", "GH");
        codes.put("ewo", "CM");
        codes.put("fan", "GQ");
        codes.put("fao", "FO");
        codes.put("fas", "IR");
        codes.put("fat", "GH");
        codes.put("fij", "FJ");
        codes.put("fil", "PH");
        codes.put("fin", "FI");
        codes.put("fon", "BJ");
        codes.put("fra", "FR");
        codes.put("frr", "DE,01");
        codes.put("frs", "DE,03");
        codes.put("fry", "NL,21");
        codes.put("ful", "SN");
        codes.put("fur", "IT,06");
        codes.put("gaa", "GH");
        codes.put("gay", "ID");
        codes.put("gba", "CF");
        codes.put("gez", "ET");
        codes.put("gil", "KI");
        codes.put("gla", "GB,S");
        codes.put("gle", "IE");
        codes.put("glg", "ES,10");
        codes.put("glv", "IM");
        codes.put("gon", "IN");
        codes.put("gor", "ID");
        codes.put("grb", "LR");
        codes.put("grn", "PY");
        codes.put("gsw", "CH");
        codes.put("guj", "IN");
        codes.put("gwi", "CA,61");
        codes.put("hai", "CA,59");
        codes.put("hat", "HT");
        codes.put("hau", "NG");
        codes.put("haw", "US,15");
        codes.put("heb", "IL");
        codes.put("her", "NA");
        codes.put("hil", "PH");
        codes.put("hin", "IN");
        codes.put("hmn", "CN");
        codes.put("hmo", "PG");
        codes.put("hrv", "HR");
        codes.put("hsb", "DE,14");
        codes.put("hun", "HU");
        codes.put("hup", "US,06");
        codes.put("hye", "AM");
        codes.put("iba", "MY");
        codes.put("ibo", "NG");
        codes.put("iii", "CN");
        codes.put("iku", "CA");
        codes.put("ilo", "PH");
        codes.put("ind", "ID");
        codes.put("inh", "RU,06");
        codes.put("ipk", "US,02");
        codes.put("isl", "IS");
        codes.put("ita", "IT");
        codes.put("jav", "ID");
        codes.put("jpn", "JP");
        codes.put("jpr", "IL,01");
        codes.put("jrb", "IL");
        codes.put("kaa", "UZ");
        codes.put("kab", "DZ");
        codes.put("kac", "MM");
        codes.put("kal", "GL");
        codes.put("kam", "KE");
        codes.put("kan", "IN");
        codes.put("kas", "IN");
        codes.put("kat", "GE");
        codes.put("kau", "NG");
        codes.put("kaz", "KZ");
        codes.put("kbd", "RU,07");
        codes.put("kha", "IN");
        codes.put("khm", "KH");
        codes.put("kik", "KE");
        codes.put("kin", "RW");
        codes.put("kir", "KG");
        codes.put("kmb", "AO");
        codes.put("kok", "IN");
        codes.put("kom", "RU,11");
        codes.put("kon", "CD");
        codes.put("kor", "KR");
        codes.put("kos", "FM");
        codes.put("kpe", "LR");
        codes.put("krc", "RU,09");
        codes.put("krl", "RU,10");
        codes.put("kru", "IN");
        codes.put("kua", "AO");
        codes.put("kum", "RU,05");
        codes.put("kur", "IQ,01");
        codes.put("kut", "CA,59");
        codes.put("lad", "IL,01");
        codes.put("lah", "PK");
        codes.put("lam", "ZM");
        codes.put("lao", "LA");
        codes.put("lav", "LV");
        codes.put("lez", "RU,05");
        codes.put("lim", "NL,31");
        codes.put("lin", "CD");
        codes.put("lit", "LT");
        codes.put("lol", "CD");
        codes.put("loz", "ZM");
        codes.put("ltz", "LU");
        codes.put("lua", "CD");
        codes.put("lub", "CD");
        codes.put("lug", "UG");
        codes.put("lui", "US,06");
        codes.put("lun", "ZM");
        codes.put("luo", "KE");
        codes.put("lus", "IN");
        codes.put("mad", "ID");
        codes.put("mag", "IN");
        codes.put("mah", "MH");
        codes.put("mai", "IN");
        codes.put("mak", "ID");
        codes.put("mal", "IN");
        codes.put("man", "GN");
        codes.put("mar", "IN");
        codes.put("mas", "KE");
        codes.put("mdf", "RU,13");
        codes.put("mdr", "ID");
        codes.put("men", "SL");
        codes.put("mic", "CA,12");
        codes.put("min", "ID");
        codes.put("mkd", "MK");
        codes.put("mlg", "MG");
        codes.put("mlt", "MT");
        codes.put("mnc", "CN");
        codes.put("mni", "IN");
        codes.put("moh", "CA,35");
        codes.put("mon", "MN");
        codes.put("mos", "BF");
        codes.put("mri", "NZ");
        codes.put("msa", "MY");
        codes.put("mus", "US,40");
        codes.put("mwl", "PT,04");
        codes.put("mwr", "IN");
        codes.put("mya", "MM");
        codes.put("myv", "RU");
        codes.put("nap", "IT,15,0063");
        codes.put("nau", "NR");
        codes.put("nav", "US");
        codes.put("nbl", "ZA");
        codes.put("nde", "ZW");
        codes.put("ndo", "NA");
        codes.put("nds", "DE,03");
        codes.put("nep", "NP");
        codes.put("new", "NP");
        codes.put("nia", "ID");
        codes.put("niu", "NU");
        codes.put("nld", "NL");
        codes.put("nno", "NO");
        codes.put("nob", "NO");
        codes.put("nog", "RU");
        codes.put("nor", "NO");
        codes.put("nqo", "GN");
        codes.put("nso", "ZA");
        codes.put("nya", "MW");
        codes.put("nym", "TZ");
        codes.put("nyn", "UG");
        codes.put("nyo", "UG");
        codes.put("nzi", "GH");
        codes.put("oci", "ES,07");
        codes.put("oji", "CA");
        codes.put("ori", "IN");
        codes.put("orm", "ET");
        codes.put("osa", "US,40");
        codes.put("oss", "RU,15");
        codes.put("pag", "PH");
        codes.put("pam", "PH");
        codes.put("pan", "IN");
        codes.put("pap", "CW");
        codes.put("pau", "PW");
        codes.put("pol", "PL");
        codes.put("pon", "FM");
        codes.put("por", "PT");
        codes.put("pus", "PK");
        codes.put("que", "PE");
        codes.put("raj", "IN");
        codes.put("rap", "CL");
        codes.put("rar", "CK");
        codes.put("roh", "CH,18");
        codes.put("rom", "RO");
        codes.put("ron", "RO");
        codes.put("run", "BI");
        codes.put("rup", "GR");
        codes.put("rus", "RU");
        codes.put("sad", "TZ");
        codes.put("sag", "CF");
        codes.put("sah", "RU,14");
        codes.put("sam", "PS");
        codes.put("san", "IN");
        codes.put("sas", "ID");
        codes.put("sat", "IN");
        codes.put("scn", "IT,19");
        codes.put("sco", "GB,S");
        codes.put("sel", "RU");
        codes.put("shn", "MM");
        codes.put("sid", "ET");
        codes.put("sin", "LK");
        codes.put("slk", "SK");
        codes.put("slv", "SI");
        codes.put("sma", "SE,23");
        codes.put("sme", "NO");
        codes.put("smj", "SE,25");
        codes.put("smn", "FI,19");
        codes.put("smo", "WS");
        codes.put("sms", "FI,19");
        codes.put("sna", "ZW");
        codes.put("snd", "PK");
        codes.put("snk", "ML");
        codes.put("som", "SO");
        codes.put("sot", "LS");
        codes.put("spa", "ES");
        codes.put("sqi", "AL");
        codes.put("srd", "IT,20");
        codes.put("srn", "SR");
        codes.put("srp", "RS");
        codes.put("srr", "SN");
        codes.put("ssw", "SZ");
        codes.put("suk", "TZ");
        codes.put("sun", "ID");
        codes.put("sus", "GN");
        codes.put("swa", "TZ");
        codes.put("swe", "SE");
        codes.put("syr", "IQ");
        codes.put("tah", "PF");
        codes.put("tam", "IN");
        codes.put("tat", "RU,16");
        codes.put("tel", "IN");
        codes.put("tem", "SL");
        codes.put("ter", "BR,03,50");
        codes.put("tet", "ID");
        codes.put("tgk", "TJ");
        codes.put("tgl", "PH");
        codes.put("tha", "TH");
        codes.put("tig", "ER");
        codes.put("tir", "ET");
        codes.put("tiv", "NG");
        codes.put("tkl", "TK");
        codes.put("tli", "US,02");
        codes.put("tmh", "ML");
        codes.put("tog", "MW");
        codes.put("ton", "TO");
        codes.put("tpi", "PG");
        codes.put("tsi", "CA,59");
        codes.put("tsn", "BW");
        codes.put("tso", "ZA");
        codes.put("tuk", "TM");
        codes.put("tum", "MW");
        codes.put("tur", "TR");
        codes.put("tvl", "TV");
        codes.put("twi", "GH");
        codes.put("tyv", "RU,17");
        codes.put("udm", "RU,18");
        codes.put("uig", "CN");
        codes.put("ukr", "UA");
        codes.put("umb", "AO");
        codes.put("urd", "PK");
        codes.put("uzb", "UZ");
        codes.put("vai", "LR");
        codes.put("ven", "ZA");
        codes.put("vie", "VN");
        codes.put("vot", "RU");
        codes.put("wal", "ET");
        codes.put("war", "PH");
        codes.put("was", "US,06");
        codes.put("wln", "BE,03");
        codes.put("wol", "SN");
        codes.put("xal", "RU,08");
        codes.put("xho", "ZA");
        codes.put("yao", "MW");
        codes.put("yap", "FM");
        codes.put("yid", "IL");
        codes.put("yor", "NG");
        codes.put("zap", "MX");
        codes.put("zen", "MR");
        codes.put("zgh", "MA");
        codes.put("zha", "CN");
        codes.put("zho", "CN");
        codes.put("zul", "ZA");
        codes.put("zun", "US,35");
        codes.put("zza", "TR");
        languageCodes = Collections.unmodifiableMap(codes);
    }
}

