/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.internal;

import java.lang.reflect.Constructor;
import org.sellcom.geotemporal.internal.Contract;

public class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static <T extends Exception> T createException(Class<T> type) {
        Contract.checkArgument(type != null, "Type must not be null", new Object[0]);
        try {
            Constructor<T> constructor = type.getConstructor(new Class[0]);
            return (T)((Exception)constructor.newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(String.format("Exception class %s is not instantiable", type.getSimpleName()), e);
        }
    }

    public static <T extends Exception> T createException(Class<T> type, String message) {
        Contract.checkArgument(type != null, "Type must not be null", new Object[0]);
        try {
            Constructor<T> constructor = type.getConstructor(String.class);
            return (T)((Exception)constructor.newInstance(message));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(String.format("Exception class %s is not instantiable", type.getSimpleName()), e);
        }
    }

    public static <T extends Exception> T createException(Class<T> type, String message, Throwable cause) {
        Contract.checkArgument(type != null, "Type must not be null", new Object[0]);
        try {
            Constructor<T> constructor = type.getConstructor(String.class, Throwable.class);
            return (T)((Exception)constructor.newInstance(message, cause));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(String.format("Exception class %s is not instantiable", type.getSimpleName()), e);
        }
    }

    public static <T extends Exception> T createException(Class<T> type, Throwable cause) {
        Contract.checkArgument(type != null, "Type must not be null", new Object[0]);
        try {
            Constructor<T> constructor = type.getConstructor(Throwable.class);
            return (T)((Exception)constructor.newInstance(cause));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(String.format("Exception class %s is not instantiable", type.getSimpleName()), e);
        }
    }
}

