/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.internal.time;

import java.time.LocalDate;
import java.time.temporal.JulianFields;
import org.sellcom.geotemporal.internal.time.JulianLocalDate;

public class CalendarConversionUtils {
    private CalendarConversionUtils() {
    }

    public static JulianLocalDate gregorianToJulian(LocalDate date) {
        return CalendarConversionUtils.julianDayToJulianDate(Math.toIntExact(date.getLong(JulianFields.JULIAN_DAY)));
    }

    public static LocalDate julianToGregorian(JulianLocalDate date) {
        return LocalDate.ofEpochDay(0L).with(JulianFields.JULIAN_DAY, CalendarConversionUtils.julianDateToJulianDay(date));
    }

    private static int julianDateToJulianDay(JulianLocalDate date) {
        int year = date.getYear();
        int month = date.getMonthValue();
        int day = date.getDayOfMonth();
        int a = (14 - month) / 12;
        int b = month + 12 * a - 3;
        int c = year + 4800 - a;
        return day + (153 * b + 2) / 5 + 365 * c + c / 4 - 32083;
    }

    private static JulianLocalDate julianDayToJulianDate(int julianDay) {
        int a = julianDay + 32082;
        int b = (4 * a + 3) / 1461;
        int c = a - 1461 * b / 4;
        int d = (5 * c + 2) / 153;
        int e = d / 10;
        int day = c - (153 * d + 2) / 5 + 1;
        int month = d + 3 - 12 * e;
        int year = b - 4800 + e;
        return JulianLocalDate.of(year, month, day);
    }
}

