/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.internal.time;

import java.time.Month;
import java.time.temporal.Temporal;
import java.util.Optional;
import org.sellcom.geotemporal.geography.GeoRegion;
import org.sellcom.geotemporal.geography.GeoRegionNotSupportedException;
import org.sellcom.geotemporal.internal.time.TemporalUtils;

public class WorkingDays {
    private WorkingDays() {
    }

    public static Optional<Boolean> isWorkingDay(Temporal temporal, GeoRegion region) {
        switch (region.getCountryCode()) {
            case "AD": {
                return Optional.empty();
            }
            case "AT": {
                return Optional.empty();
            }
            case "BE": {
                return Optional.empty();
            }
            case "HR": {
                return Optional.empty();
            }
            case "CY": {
                return Optional.empty();
            }
            case "CZ": {
                return Optional.empty();
            }
            case "DK": {
                return Optional.empty();
            }
            case "EE": {
                return Optional.empty();
            }
            case "FO": {
                return Optional.empty();
            }
            case "FI": {
                return Optional.empty();
            }
            case "FR": {
                return Optional.empty();
            }
            case "GE": {
                return Optional.empty();
            }
            case "DE": {
                return Optional.empty();
            }
            case "GL": {
                return Optional.empty();
            }
            case "GG": {
                return Optional.empty();
            }
            case "HU": {
                return WorkingDays.isWorkingDay_hungary(temporal, region);
            }
            case "IS": {
                return Optional.empty();
            }
            case "IM": {
                return Optional.empty();
            }
            case "IT": {
                return Optional.empty();
            }
            case "JE": {
                return Optional.empty();
            }
            case "LV": {
                return WorkingDays.isWorkingDay_latvia(temporal, region);
            }
            case "LI": {
                return Optional.empty();
            }
            case "MT": {
                return Optional.empty();
            }
            case "NL": {
                return Optional.empty();
            }
            case "NO": {
                return Optional.empty();
            }
            case "PL": {
                return Optional.empty();
            }
            case "PT": {
                return Optional.empty();
            }
            case "IE": {
                return Optional.empty();
            }
            case "RO": {
                return Optional.empty();
            }
            case "RS": {
                return Optional.empty();
            }
            case "SK": {
                return Optional.empty();
            }
            case "SI": {
                return Optional.empty();
            }
            case "SE": {
                return Optional.empty();
            }
            case "CH": {
                return Optional.empty();
            }
            case "GB": {
                return Optional.empty();
            }
            case "VA": {
                return Optional.empty();
            }
        }
        throw new GeoRegionNotSupportedException(String.format("Unsupported region: %s", region));
    }

    private static Optional<Boolean> isWorkingDay_hungary(Temporal temporal, GeoRegion region) {
        if (TemporalUtils.is(temporal, 2014, Month.MAY, 2)) {
            return Optional.of(false);
        }
        if (TemporalUtils.is(temporal, 2014, Month.MAY, 10)) {
            return Optional.of(true);
        }
        if (TemporalUtils.is(temporal, 2014, Month.OCTOBER, 18)) {
            return Optional.of(true);
        }
        if (TemporalUtils.is(temporal, 2014, Month.OCTOBER, 24)) {
            return Optional.of(false);
        }
        if (TemporalUtils.is(temporal, 2014, Month.DECEMBER, 13)) {
            return Optional.of(true);
        }
        if (TemporalUtils.is(temporal, 2014, Month.DECEMBER, 24)) {
            return Optional.of(false);
        }
        if (TemporalUtils.is(temporal, 2015, Month.JANUARY, 2)) {
            return Optional.of(false);
        }
        if (TemporalUtils.is(temporal, 2015, Month.JANUARY, 10)) {
            return Optional.of(true);
        }
        if (TemporalUtils.is(temporal, 2015, Month.AUGUST, 8)) {
            return Optional.of(true);
        }
        if (TemporalUtils.is(temporal, 2015, Month.AUGUST, 21)) {
            return Optional.of(false);
        }
        if (TemporalUtils.is(temporal, 2015, Month.DECEMBER, 12)) {
            return Optional.of(true);
        }
        if (TemporalUtils.is(temporal, 2015, Month.DECEMBER, 24)) {
            return Optional.of(false);
        }
        if (TemporalUtils.is(temporal, 2016, Month.MARCH, 5)) {
            return Optional.of(true);
        }
        if (TemporalUtils.is(temporal, 2016, Month.MARCH, 14)) {
            return Optional.of(false);
        }
        if (TemporalUtils.is(temporal, 2016, Month.OCTOBER, 15)) {
            return Optional.of(true);
        }
        if (TemporalUtils.is(temporal, 2016, Month.OCTOBER, 31)) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    private static Optional<Boolean> isWorkingDay_latvia(Temporal temporal, GeoRegion region) {
        if (TemporalUtils.is(temporal, 2014, Month.MAY, 2)) {
            return Optional.of(false);
        }
        if (TemporalUtils.is(temporal, 2014, Month.MAY, 10)) {
            return Optional.of(true);
        }
        if (TemporalUtils.is(temporal, 2014, Month.NOVEMBER, 17)) {
            return Optional.of(false);
        }
        if (TemporalUtils.is(temporal, 2014, Month.NOVEMBER, 22)) {
            return Optional.of(true);
        }
        if (TemporalUtils.is(temporal, 2015, Month.JANUARY, 2)) {
            return Optional.of(false);
        }
        if (TemporalUtils.is(temporal, 2015, Month.JANUARY, 10)) {
            return Optional.of(true);
        }
        if (TemporalUtils.is(temporal, 2015, Month.JUNE, 22)) {
            return Optional.of(false);
        }
        if (TemporalUtils.is(temporal, 2015, Month.JUNE, 27)) {
            return Optional.of(true);
        }
        if (TemporalUtils.is(temporal, 2017, Month.MAY, 5)) {
            return Optional.of(false);
        }
        if (TemporalUtils.is(temporal, 2017, Month.MAY, 13)) {
            return Optional.of(true);
        }
        return Optional.empty();
    }
}

