/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.internal.time.applicability;

import java.time.DayOfWeek;
import java.time.temporal.Temporal;
import org.sellcom.geotemporal.internal.Contract;
import org.sellcom.geotemporal.time.DaysOfWeek;
import org.sellcom.geotemporal.time.applicability.TemporalApplicability;

public final class RangeOfDaysOfWeekApplicability
extends TemporalApplicability {
    private final DayOfWeek endDayOfWeek;
    private final DayOfWeek startDayOfWeek;

    public RangeOfDaysOfWeekApplicability(DayOfWeek startDayOfWeek, DayOfWeek endDayOfWeek) {
        Contract.checkArgument(startDayOfWeek != null, "Start day of week must not be null", new Object[0]);
        Contract.checkArgument(endDayOfWeek != null, "End day of week must not be null", new Object[0]);
        this.startDayOfWeek = startDayOfWeek;
        this.endDayOfWeek = endDayOfWeek;
    }

    @Override
    public boolean test(Temporal temporal) {
        Contract.checkArgument(temporal != null, "Temporal must not be null", new Object[0]);
        return DaysOfWeek.isInRange(DayOfWeek.from(temporal), this.startDayOfWeek, this.endDayOfWeek);
    }
}

