/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.internal.time.applicability;

import java.time.temporal.Temporal;
import org.sellcom.geotemporal.internal.Contract;
import org.sellcom.geotemporal.time.Temporals;
import org.sellcom.geotemporal.time.applicability.TemporalApplicability;

public class RangeOfIsoWeekNumbersApplicability
extends TemporalApplicability {
    private final int endIsoWeekNumber;
    private final int startIsoWeekNumber;

    public RangeOfIsoWeekNumbersApplicability(int startIsoWeekNumber, int endIsoWeekNumber) {
        Contract.checkArgument(startIsoWeekNumber >= 1, "Start ISO week number must be positive: {0}", startIsoWeekNumber);
        Contract.checkArgument(startIsoWeekNumber <= 53, "Start ISO week number must be at most 53: {0}", startIsoWeekNumber);
        Contract.checkArgument(endIsoWeekNumber >= 1, "End ISO week number must be positive: {0}", endIsoWeekNumber);
        Contract.checkArgument(endIsoWeekNumber <= 53, "End ISO week number must be at most 53: {0}", endIsoWeekNumber);
        this.startIsoWeekNumber = startIsoWeekNumber;
        this.endIsoWeekNumber = endIsoWeekNumber;
    }

    @Override
    public boolean test(Temporal temporal) {
        Contract.checkArgument(temporal != null, "Temporal must not be null", new Object[0]);
        int isoWeekNumber = Temporals.getIsoWeekNumber(temporal);
        return isoWeekNumber >= this.startIsoWeekNumber && isoWeekNumber <= this.endIsoWeekNumber;
    }
}

