/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.internal.time.applicability;

import java.time.LocalDate;
import java.time.temporal.Temporal;
import org.sellcom.geotemporal.internal.Contract;
import org.sellcom.geotemporal.time.LocalDates;
import org.sellcom.geotemporal.time.applicability.TemporalApplicability;

public final class RangeOfLocalDatesApplicability
extends TemporalApplicability {
    private final LocalDate endDate;
    private final LocalDate startDate;

    public RangeOfLocalDatesApplicability(LocalDate startDate, LocalDate endDate) {
        Contract.checkArgument(startDate != null, "Start date must not be null", new Object[0]);
        Contract.checkArgument(endDate != null, "End date must not be null", new Object[0]);
        this.startDate = startDate;
        this.endDate = endDate;
    }

    @Override
    public boolean test(Temporal temporal) {
        Contract.checkArgument(temporal != null, "Temporal must not be null", new Object[0]);
        return LocalDates.isInRange(LocalDate.from(temporal), this.startDate, this.endDate);
    }
}

