/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.internal.time.applicability;

import java.time.Year;
import java.time.temporal.Temporal;
import org.sellcom.geotemporal.internal.Contract;
import org.sellcom.geotemporal.time.Years;
import org.sellcom.geotemporal.time.applicability.TemporalApplicability;

public final class RangeOfYearsApplicability
extends TemporalApplicability {
    private final Year endYear;
    private final Year startYear;

    public RangeOfYearsApplicability(int startYear, int endYear) {
        this.startYear = Year.of(startYear);
        this.endYear = Year.of(endYear);
    }

    @Override
    public boolean test(Temporal date) {
        Contract.checkArgument(date != null, "Temporal must not be null", new Object[0]);
        return Years.isInRange(Year.from(date), this.startYear, this.endYear);
    }
}

