/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.internal.time.applicability;

import java.time.DayOfWeek;
import java.time.temporal.Temporal;
import org.sellcom.geotemporal.internal.Contract;
import org.sellcom.geotemporal.time.applicability.TemporalApplicability;

public final class SingleDayOfWeekApplicability
extends TemporalApplicability {
    private final DayOfWeek dayOfWeek;

    public SingleDayOfWeekApplicability(DayOfWeek dayOfWeek) {
        Contract.checkArgument(dayOfWeek != null, "Day of week must not be null", new Object[0]);
        this.dayOfWeek = dayOfWeek;
    }

    @Override
    public boolean test(Temporal temporal) {
        Contract.checkArgument(temporal != null, "Temporal must not be null", new Object[0]);
        return this.dayOfWeek.equals(DayOfWeek.from(temporal));
    }
}

