/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.internal.time.applicability;

import java.time.LocalDate;
import java.time.temporal.Temporal;
import org.sellcom.geotemporal.internal.Contract;
import org.sellcom.geotemporal.time.applicability.TemporalApplicability;

public final class SingleLocalDateApplicability
extends TemporalApplicability {
    private final LocalDate date;

    public SingleLocalDateApplicability(LocalDate date) {
        Contract.checkArgument(date != null, "Date must not be null", new Object[0]);
        this.date = date;
    }

    @Override
    public boolean test(Temporal temporal) {
        Contract.checkArgument(temporal != null, "Temporal must not be null", new Object[0]);
        return this.date.equals(LocalDate.from(temporal));
    }
}

