/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.internal.time.applicability;

import java.time.MonthDay;
import java.time.temporal.Temporal;
import org.sellcom.geotemporal.internal.Contract;
import org.sellcom.geotemporal.time.applicability.TemporalApplicability;

public final class SingleMonthDayApplicability
extends TemporalApplicability {
    private final MonthDay monthDay;

    public SingleMonthDayApplicability(MonthDay monthDay) {
        Contract.checkArgument(monthDay != null, "Month-day must not be null", new Object[0]);
        this.monthDay = monthDay;
    }

    @Override
    public boolean test(Temporal temporal) {
        Contract.checkArgument(temporal != null, "Temporal must not be null", new Object[0]);
        return this.monthDay.equals(MonthDay.from(temporal));
    }
}

