/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.internal.time.applicability.parser;

import java.text.MessageFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.MonthDay;
import java.time.format.DateTimeParseException;
import java.util.EnumSet;
import org.sellcom.geotemporal.internal.time.applicability.parser.MatcherUtils;
import org.sellcom.geotemporal.internal.time.applicability.parser.ParameterTokenizer;
import org.sellcom.geotemporal.time.HolidayType;
import org.sellcom.geotemporal.time.applicability.GeoTemporalApplicability;
import org.sellcom.geotemporal.time.applicability.GeoTemporalApplicabilityParseException;
import org.sellcom.geotemporal.time.applicability.TemporalApplicability;

class ParserUtils {
    private ParserUtils() {
    }

    static GeoTemporalApplicability parseLocalDateApplicability(String rule) {
        try {
            String prefix;
            switch (prefix = MatcherUtils.getPrefix(rule)) {
                case "dateRange[": {
                    ParameterTokenizer parameterTokenizer = new ParameterTokenizer(rule, prefix.length());
                    String startDateExpression = parameterTokenizer.tokenAt(0);
                    LocalDate startDate = LocalDate.parse(startDateExpression);
                    String endDateExpression = parameterTokenizer.tokenAt(1);
                    LocalDate endDate = LocalDate.parse(endDateExpression);
                    return TemporalApplicability.dateRange(startDate, endDate);
                }
                case "dayOfWeekAfter[": {
                    ParameterTokenizer parameterTokenizer = new ParameterTokenizer(rule, prefix.length());
                    String ordinalExpression = parameterTokenizer.tokenAt(0);
                    int ordinal = Integer.parseInt(ordinalExpression);
                    String dayOfWeekExpression = parameterTokenizer.tokenAt(1);
                    DayOfWeek dayOfWeek = ParserUtils.parseDayOfWeek(dayOfWeekExpression);
                    String monthDayExpression = parameterTokenizer.tokenAt(2);
                    MonthDay monthDay = MonthDay.parse("--" + monthDayExpression);
                    return TemporalApplicability.dayOfWeekAfter(ordinal, dayOfWeek, monthDay);
                }
                case "dayOfWeekBefore[": {
                    ParameterTokenizer parameterTokenizer = new ParameterTokenizer(rule, prefix.length());
                    String ordinalExpression = parameterTokenizer.tokenAt(0);
                    int ordinal = Integer.parseInt(ordinalExpression);
                    String dayOfWeekExpression = parameterTokenizer.tokenAt(1);
                    DayOfWeek dayOfWeek = ParserUtils.parseDayOfWeek(dayOfWeekExpression);
                    String monthDayExpression = parameterTokenizer.tokenAt(2);
                    MonthDay monthDay = MonthDay.parse("--" + monthDayExpression);
                    return TemporalApplicability.dayOfWeekBefore(ordinal, dayOfWeek, monthDay);
                }
                case "dayOfWeekRange[": {
                    ParameterTokenizer parameterTokenizer = new ParameterTokenizer(rule, prefix.length());
                    String startDayOfWeekExpression = parameterTokenizer.tokenAt(0);
                    DayOfWeek startDayOfWeek = ParserUtils.parseDayOfWeek(startDayOfWeekExpression);
                    String endDayOfWeekExpression = parameterTokenizer.tokenAt(1);
                    DayOfWeek endDayOfWeek = ParserUtils.parseDayOfWeek(endDayOfWeekExpression);
                    return TemporalApplicability.dayOfWeekRange(startDayOfWeek, endDayOfWeek);
                }
                case "false": {
                    return TemporalApplicability.never();
                }
                case "holiday[": {
                    ParameterTokenizer parameterTokenizer = new ParameterTokenizer(rule, prefix.length());
                    EnumSet<HolidayType> types = EnumSet.noneOf(HolidayType.class);
                    int j = parameterTokenizer.tokens();
                    block70: for (int i = 0; i < j; ++i) {
                        String type;
                        switch (type = parameterTokenizer.tokenAt(i)) {
                            case "B": {
                                types.add(HolidayType.BANKS_AND_FINANCIAL_INSTITUTIONS_ONLY);
                                continue block70;
                            }
                            case "G": {
                                types.add(HolidayType.GOVERNMENT_SERVICES_ONLY);
                                continue block70;
                            }
                            case "P": {
                                types.add(HolidayType.PUBLIC);
                                continue block70;
                            }
                            case "S": {
                                types.add(HolidayType.SCHOOLS_ONLY);
                                continue block70;
                            }
                            case "U": {
                                types.add(HolidayType.SCHOOLS_AND_UNIVERSITIES_ONLY);
                                continue block70;
                            }
                            default: {
                                throw new GeoTemporalApplicabilityParseException(MessageFormat.format("Token \"{0}\" contains unsupported holiday type \"{1}\"", rule, type));
                            }
                        }
                    }
                    if (types.isEmpty()) {
                        throw new GeoTemporalApplicabilityParseException(MessageFormat.format("Token \"{0}\" contains no holiday types", rule));
                    }
                    return GeoTemporalApplicability.holiday(types);
                }
                case "isoWeek[": {
                    ParameterTokenizer parameterTokenizer = new ParameterTokenizer(rule, prefix.length());
                    switch (parameterTokenizer.tokenAt(0)) {
                        case "even": {
                            return TemporalApplicability.evenIsoWeek();
                        }
                        case "odd": {
                            return TemporalApplicability.oddIsoWeek();
                        }
                    }
                    throw new GeoTemporalApplicabilityParseException(MessageFormat.format("Token \"{0}\" could not be parsed", rule));
                }
                case "isoWeekRange[": {
                    ParameterTokenizer parameterTokenizer = new ParameterTokenizer(rule, prefix.length());
                    String startWeekNumberExpression = parameterTokenizer.tokenAt(0);
                    int startWeekNumber = Integer.parseInt(startWeekNumberExpression);
                    String endTimeExpression = parameterTokenizer.tokenAt(1);
                    int endWeekNumber = Integer.parseInt(endTimeExpression);
                    return TemporalApplicability.isoWeekRange(startWeekNumber, endWeekNumber);
                }
                case "monthDayRange[": {
                    ParameterTokenizer parameterTokenizer = new ParameterTokenizer(rule, prefix.length());
                    String startMonthDayExpression = parameterTokenizer.tokenAt(0);
                    MonthDay startMonthDay = MonthDay.parse("--" + startMonthDayExpression);
                    String endMonthDayExpression = parameterTokenizer.tokenAt(1);
                    MonthDay endMonthDay = MonthDay.parse("--" + endMonthDayExpression);
                    return TemporalApplicability.monthDayRange(startMonthDay, endMonthDay);
                }
                case "monthRange[": {
                    ParameterTokenizer parameterTokenizer = new ParameterTokenizer(rule, prefix.length());
                    String startMonthExpression = parameterTokenizer.tokenAt(0);
                    Month startMonth = Month.of(Integer.parseInt(startMonthExpression, 10));
                    String endMonthExpression = parameterTokenizer.tokenAt(1);
                    Month endMonth = Month.of(Integer.parseInt(endMonthExpression, 10));
                    return TemporalApplicability.monthRange(startMonth, endMonth);
                }
                case "publicHoliday[": {
                    return GeoTemporalApplicability.publicHoliday();
                }
                case "schoolHoliday[": {
                    return GeoTemporalApplicability.schoolHoliday();
                }
                case "singleDate[": {
                    ParameterTokenizer parameterTokenizer = new ParameterTokenizer(rule, prefix.length());
                    String dateExpression = parameterTokenizer.tokenAt(0);
                    LocalDate date = LocalDate.parse(dateExpression);
                    return TemporalApplicability.singleDate(date);
                }
                case "singleDayOfWeek[": {
                    ParameterTokenizer parameterTokenizer = new ParameterTokenizer(rule, prefix.length());
                    String dayOfWeekExpression = parameterTokenizer.tokenAt(0);
                    DayOfWeek dayOfWeek = ParserUtils.parseDayOfWeek(dayOfWeekExpression);
                    return TemporalApplicability.singleDayOfWeek(dayOfWeek);
                }
                case "singleIsoWeek[": {
                    ParameterTokenizer parameterTokenizer = new ParameterTokenizer(rule, prefix.length());
                    String argumentExpression = parameterTokenizer.tokenAt(0);
                    int weekNumber = Integer.parseInt(argumentExpression);
                    return TemporalApplicability.singleIsoWeek(weekNumber);
                }
                case "singleMonth[": {
                    ParameterTokenizer parameterTokenizer = new ParameterTokenizer(rule, prefix.length());
                    String monthExpression = parameterTokenizer.tokenAt(0);
                    Month month = Month.of(Integer.parseInt(monthExpression, 10));
                    return TemporalApplicability.singleMonth(month);
                }
                case "singleMonthDay[": {
                    ParameterTokenizer parameterTokenizer = new ParameterTokenizer(rule, prefix.length());
                    String monthDayExpression = parameterTokenizer.tokenAt(0);
                    MonthDay monthDay = MonthDay.parse("--" + monthDayExpression);
                    return TemporalApplicability.singleMonthDay(monthDay);
                }
                case "singleYear[": {
                    ParameterTokenizer parameterTokenizer = new ParameterTokenizer(rule, prefix.length());
                    String yearExpression = parameterTokenizer.tokenAt(0);
                    int year = Integer.parseInt(yearExpression, 10);
                    return TemporalApplicability.singleYear(year);
                }
                case "true": {
                    return TemporalApplicability.always();
                }
                case "weekend[": {
                    return GeoTemporalApplicability.weekend();
                }
                case "yearRange[": {
                    ParameterTokenizer parameterTokenizer = new ParameterTokenizer(rule, prefix.length());
                    String startYearExpression = parameterTokenizer.tokenAt(0);
                    int startYear = Integer.parseInt(startYearExpression, 10);
                    String endYearExpression = parameterTokenizer.tokenAt(1);
                    int endYear = Integer.parseInt(endYearExpression, 10);
                    return TemporalApplicability.yearRange(startYear, endYear);
                }
            }
            throw new GeoTemporalApplicabilityParseException(MessageFormat.format("Token \"{0}\" could not be parsed", rule));
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException | DateTimeParseException e) {
            throw new GeoTemporalApplicabilityParseException(MessageFormat.format("Token \"{0}\" could not be parsed", rule), e);
        }
    }

    private static DayOfWeek parseDayOfWeek(String rule) {
        switch (rule) {
            case "Mon": {
                return DayOfWeek.MONDAY;
            }
            case "Tue": {
                return DayOfWeek.TUESDAY;
            }
            case "Wed": {
                return DayOfWeek.WEDNESDAY;
            }
            case "Thu": {
                return DayOfWeek.THURSDAY;
            }
            case "Fri": {
                return DayOfWeek.FRIDAY;
            }
            case "Sat": {
                return DayOfWeek.SATURDAY;
            }
            case "Sun": {
                return DayOfWeek.SUNDAY;
            }
        }
        throw new GeoTemporalApplicabilityParseException(MessageFormat.format("Token \"{0}\" could not be parsed", rule));
    }
}

