/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.time;

import java.time.DayOfWeek;
import org.sellcom.geotemporal.internal.Contract;

public class DaysOfWeek {
    private DaysOfWeek() {
    }

    public static boolean isAfter(DayOfWeek former, DayOfWeek latter) {
        Contract.checkArgument(former != null, "Former day of week must not be null", new Object[0]);
        Contract.checkArgument(former != null, "Latter day of week must not be null", new Object[0]);
        return former.compareTo(latter) > 0;
    }

    public static boolean isBefore(DayOfWeek former, DayOfWeek latter) {
        Contract.checkArgument(former != null, "Former day of week must not be null", new Object[0]);
        Contract.checkArgument(former != null, "Latter day of week must not be null", new Object[0]);
        return former.compareTo(latter) < 0;
    }

    public static boolean isInRange(DayOfWeek dayOfWeek, DayOfWeek startDayOfWeek, DayOfWeek endDayOfWeek) {
        Contract.checkArgument(dayOfWeek != null, "Day-of-week month not be null", new Object[0]);
        Contract.checkArgument(startDayOfWeek != null, "Start day-of-week must not be null", new Object[0]);
        Contract.checkArgument(endDayOfWeek != null, "End day-of-week must not be null", new Object[0]);
        if (DaysOfWeek.isAfter(startDayOfWeek, endDayOfWeek)) {
            return !DaysOfWeek.isBefore(dayOfWeek, startDayOfWeek) || !DaysOfWeek.isAfter(dayOfWeek, endDayOfWeek);
        }
        return !DaysOfWeek.isBefore(dayOfWeek, startDayOfWeek) && !DaysOfWeek.isAfter(dayOfWeek, endDayOfWeek);
    }

    public static DayOfWeek next(DayOfWeek dayOfWeek) {
        Contract.checkArgument(dayOfWeek != null, "Day of week must not be null", new Object[0]);
        int value = dayOfWeek.getValue();
        value = value == 7 ? 1 : value + 1;
        return DayOfWeek.of(value);
    }

    public static DayOfWeek previous(DayOfWeek dayOfWeek) {
        Contract.checkArgument(dayOfWeek != null, "Day of week must not be null", new Object[0]);
        int value = dayOfWeek.getValue();
        value = value == 1 ? 7 : value - 1;
        return DayOfWeek.of(value);
    }
}

