/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.time;

import java.time.Month;
import org.sellcom.geotemporal.internal.Contract;

public class Months {
    private Months() {
    }

    public static boolean isAfter(Month former, Month latter) {
        Contract.checkArgument(former != null, "Former month must not be null", new Object[0]);
        Contract.checkArgument(former != null, "Latter month must not be null", new Object[0]);
        return former.compareTo(latter) > 0;
    }

    public static boolean isBefore(Month former, Month latter) {
        Contract.checkArgument(former != null, "Former month must not be null", new Object[0]);
        Contract.checkArgument(former != null, "Latter month must not be null", new Object[0]);
        return former.compareTo(latter) < 0;
    }

    public static boolean isInRange(Month month, Month startMonth, Month endMonth) {
        Contract.checkArgument(month != null, "Date month not be null", new Object[0]);
        Contract.checkArgument(startMonth != null, "Start month must not be null", new Object[0]);
        Contract.checkArgument(endMonth != null, "End month must not be null", new Object[0]);
        if (Months.isAfter(startMonth, endMonth)) {
            return !Months.isBefore(month, startMonth) || !Months.isAfter(month, endMonth);
        }
        return !Months.isBefore(month, startMonth) && !Months.isAfter(month, endMonth);
    }

    public static Month next(Month month) {
        Contract.checkArgument(month != null, "Month must not be null", new Object[0]);
        int value = month.getValue();
        value = value == 12 ? 1 : value + 1;
        return Month.of(value);
    }

    public static Month previous(Month month) {
        Contract.checkArgument(month != null, "Month must not be null", new Object[0]);
        int value = month.getValue();
        value = value == 1 ? 12 : value - 1;
        return Month.of(value);
    }
}

