/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.time;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.MonthDay;
import java.time.Year;
import java.time.chrono.ChronoLocalDate;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import java.util.HashMap;
import java.util.Map;
import org.sellcom.geotemporal.geography.GeoRegion;
import org.sellcom.geotemporal.internal.Contract;
import org.sellcom.geotemporal.internal.time.CalendarConversionUtils;
import org.sellcom.geotemporal.internal.time.JulianLocalDate;
import org.sellcom.geotemporal.time.MonthDays;
import org.sellcom.geotemporal.time.Temporals;

public class MoreTemporalAdjusters {
    private static final Map<Integer, MonthDay> easterSundays = new HashMap<Integer, MonthDay>();
    private static final Map<Integer, MonthDay> orthodoxEasterSundays = new HashMap<Integer, MonthDay>();

    private MoreTemporalAdjusters() {
    }

    public static TemporalAdjuster adventSunday() {
        return temporal -> temporal.with(ChronoField.MONTH_OF_YEAR, Month.DECEMBER.getValue()).with(ChronoField.DAY_OF_MONTH, 25L).with(MoreTemporalAdjusters.dayOfWeekPreceding(4, DayOfWeek.SUNDAY));
    }

    public static TemporalAdjuster ascensionThursday() {
        return temporal -> temporal.with(MoreTemporalAdjusters.easterSunday()).plus(39L, ChronoUnit.DAYS);
    }

    public static TemporalAdjuster ashWednesday() {
        return temporal -> temporal.with(MoreTemporalAdjusters.easterSunday()).minus(46L, ChronoUnit.DAYS);
    }

    public static TemporalAdjuster bussUndBettag() {
        return temporal -> temporal.with(MoreTemporalAdjusters.adventSunday()).minus(11L, ChronoUnit.DAYS);
    }

    public static TemporalAdjuster cleanMonday() {
        return temporal -> temporal.with(MoreTemporalAdjusters.orthodoxEasterSunday()).minus(48L, ChronoUnit.DAYS);
    }

    public static TemporalAdjuster corpusChristi() {
        return temporal -> temporal.with(MoreTemporalAdjusters.easterSunday()).plus(60L, ChronoUnit.DAYS);
    }

    public static TemporalAdjuster dayOfWeekFollowing(int ordinal, DayOfWeek dayOfWeek) {
        Contract.checkArgument(ordinal != 0, "Ordinal must not be zero", new Object[0]);
        Contract.checkArgument(dayOfWeek != null, "Day of week must not be null", new Object[0]);
        if (ordinal < 0) {
            return MoreTemporalAdjusters.dayOfWeekPreceding(-ordinal, dayOfWeek);
        }
        return temporal -> temporal.with(TemporalAdjusters.next(dayOfWeek)).plus(ordinal - 1, ChronoUnit.WEEKS);
    }

    public static TemporalAdjuster dayOfWeekPreceding(int ordinal, DayOfWeek dayOfWeek) {
        Contract.checkArgument(ordinal != 0, "Ordinal must not be zero", new Object[0]);
        Contract.checkArgument(dayOfWeek != null, "Day of week must not be null", new Object[0]);
        if (ordinal < 0) {
            return MoreTemporalAdjusters.dayOfWeekFollowing(-ordinal, dayOfWeek);
        }
        return temporal -> temporal.with(TemporalAdjusters.previous(dayOfWeek)).minus(ordinal - 1, ChronoUnit.WEEKS);
    }

    public static TemporalAdjuster easterMonday() {
        return temporal -> temporal.with(MoreTemporalAdjusters.easterSunday()).plus(1L, ChronoUnit.DAYS);
    }

    public static TemporalAdjuster easterSunday() {
        return temporal -> {
            MonthDay easterSunday = easterSundays.computeIfAbsent(temporal.get(ChronoField.YEAR), MoreTemporalAdjusters::computeEasterSunday);
            return temporal.with(ChronoField.MONTH_OF_YEAR, easterSunday.getMonthValue()).with(ChronoField.DAY_OF_MONTH, easterSunday.getDayOfMonth());
        };
    }

    public static TemporalAdjuster goodFriday() {
        return temporal -> temporal.with(MoreTemporalAdjusters.easterSunday()).minus(2L, ChronoUnit.DAYS);
    }

    public static TemporalAdjuster holySaturday() {
        return temporal -> temporal.with(MoreTemporalAdjusters.easterSunday()).minus(1L, ChronoUnit.DAYS);
    }

    public static TemporalAdjuster holyWednesday() {
        return temporal -> temporal.with(MoreTemporalAdjusters.easterSunday()).minus(4L, ChronoUnit.DAYS);
    }

    public static TemporalAdjuster maundyThursday() {
        return temporal -> temporal.with(MoreTemporalAdjusters.easterSunday()).minus(3L, ChronoUnit.DAYS);
    }

    public static TemporalAdjuster next(MonthDay monthDay) {
        Contract.checkArgument(monthDay != null, "MonthDay must not be null", new Object[0]);
        return TemporalAdjusters.ofDateAdjuster(date -> {
            if (MonthDays.is(monthDay, Month.FEBRUARY, 29)) {
                LocalDate candidate = (date = date.with(MoreTemporalAdjusters.nextOrSameLeapYear())).with(monthDay);
                return candidate.isAfter((ChronoLocalDate)date) ? candidate : candidate.with(MoreTemporalAdjusters.nextLeapYear());
            }
            LocalDate candidate = date.with(monthDay);
            return candidate.isAfter((ChronoLocalDate)date) ? candidate : candidate.plusYears(1L);
        });
    }

    public static TemporalAdjuster nextDay() {
        return TemporalAdjusters.ofDateAdjuster(date -> date.plus(1L, ChronoUnit.DAYS));
    }

    public static TemporalAdjuster nextLeapYear() {
        return temporal -> {
            int year = temporal.get(ChronoField.YEAR) + 1;
            if (!Year.isLeap(year = (int)(Math.ceil((double)year / 4.0) * 4.0))) {
                year += 4;
            }
            return temporal.with(ChronoField.YEAR, year);
        };
    }

    public static TemporalAdjuster nextOrSame(MonthDay monthDay) {
        Contract.checkArgument(monthDay != null, "MonthDay must not be null", new Object[0]);
        return TemporalAdjusters.ofDateAdjuster(date -> {
            if (MonthDays.is(monthDay, Month.FEBRUARY, 29)) {
                LocalDate candidate = (date = date.with(MoreTemporalAdjusters.nextOrSameLeapYear())).with(monthDay);
                return candidate.isBefore((ChronoLocalDate)date) ? candidate.with(MoreTemporalAdjusters.nextLeapYear()) : candidate;
            }
            LocalDate candidate = date.with(monthDay);
            return candidate.isBefore((ChronoLocalDate)date) ? candidate.plusYears(1L) : candidate;
        });
    }

    public static TemporalAdjuster nextOrSameLeapYear() {
        return temporal -> {
            int year = temporal.get(ChronoField.YEAR);
            if (Year.isLeap(year)) {
                return temporal;
            }
            if (!Year.isLeap(year = (int)(Math.ceil((double)year / 4.0) * 4.0))) {
                year += 4;
            }
            return temporal.with(ChronoField.YEAR, year);
        };
    }

    public static TemporalAdjuster nextOrSameWorkingDay(GeoRegion region) {
        Contract.checkArgument(region != null, "Region must not be null", new Object[0]);
        return temporal -> {
            while (!Temporals.isWorkingDay(temporal, region)) {
                temporal = temporal.plus(1L, ChronoUnit.DAYS);
            }
            return temporal;
        };
    }

    public static TemporalAdjuster nextWorkingDay(GeoRegion region) {
        Contract.checkArgument(region != null, "Region must not be null", new Object[0]);
        return temporal -> {
            while (!Temporals.isWorkingDay(temporal = temporal.plus(1L, ChronoUnit.DAYS), region)) {
            }
            return temporal;
        };
    }

    public static TemporalAdjuster orthodoxAllSaintsDay() {
        return temporal -> temporal.with(MoreTemporalAdjusters.orthodoxEasterSunday()).plus(56L, ChronoUnit.DAYS);
    }

    public static TemporalAdjuster orthodoxAscensionThursday() {
        return temporal -> temporal.with(MoreTemporalAdjusters.orthodoxEasterSunday()).plus(39L, ChronoUnit.DAYS);
    }

    public static TemporalAdjuster orthodoxEasterMonday() {
        return temporal -> temporal.with(MoreTemporalAdjusters.orthodoxEasterSunday()).plus(1L, ChronoUnit.DAYS);
    }

    public static TemporalAdjuster orthodoxEasterSunday() {
        return temporal -> {
            MonthDay easterSunday = orthodoxEasterSundays.computeIfAbsent(temporal.get(ChronoField.YEAR), MoreTemporalAdjusters::computeOrthodoxEasterSunday);
            return temporal.with(ChronoField.MONTH_OF_YEAR, easterSunday.getMonthValue()).with(ChronoField.DAY_OF_MONTH, easterSunday.getDayOfMonth());
        };
    }

    public static TemporalAdjuster orthodoxGoodFriday() {
        return temporal -> temporal.with(MoreTemporalAdjusters.orthodoxEasterSunday()).minus(2L, ChronoUnit.DAYS);
    }

    public static TemporalAdjuster orthodoxHolySaturday() {
        return temporal -> temporal.with(MoreTemporalAdjusters.orthodoxEasterSunday()).minus(1L, ChronoUnit.DAYS);
    }

    public static TemporalAdjuster orthodoxHolyWednesday() {
        return temporal -> temporal.with(MoreTemporalAdjusters.orthodoxEasterSunday()).minus(4L, ChronoUnit.DAYS);
    }

    public static TemporalAdjuster orthodoxMaundyThursday() {
        return temporal -> temporal.with(MoreTemporalAdjusters.orthodoxEasterSunday()).minus(3L, ChronoUnit.DAYS);
    }

    public static TemporalAdjuster orthodoxPalmSunday() {
        return temporal -> temporal.with(MoreTemporalAdjusters.orthodoxEasterSunday()).minus(7L, ChronoUnit.DAYS);
    }

    public static TemporalAdjuster orthodoxWhitMonday() {
        return temporal -> temporal.with(MoreTemporalAdjusters.orthodoxEasterSunday()).plus(50L, ChronoUnit.DAYS);
    }

    public static TemporalAdjuster orthodoxWhitSunday() {
        return temporal -> temporal.with(MoreTemporalAdjusters.orthodoxEasterSunday()).plus(49L, ChronoUnit.DAYS);
    }

    public static TemporalAdjuster palmSunday() {
        return temporal -> temporal.with(MoreTemporalAdjusters.easterSunday()).minus(7L, ChronoUnit.DAYS);
    }

    public static TemporalAdjuster previous(MonthDay monthDay) {
        Contract.checkArgument(monthDay != null, "MonthDay must not be null", new Object[0]);
        return TemporalAdjusters.ofDateAdjuster(date -> {
            if (MonthDays.is(monthDay, Month.FEBRUARY, 29)) {
                LocalDate candidate = (date = date.with(MoreTemporalAdjusters.previousOrSameLeapYear())).with(monthDay);
                return candidate.isBefore((ChronoLocalDate)date) ? candidate : candidate.with(MoreTemporalAdjusters.previousLeapYear());
            }
            LocalDate candidate = date.with(monthDay);
            return candidate.isBefore((ChronoLocalDate)date) ? candidate : candidate.minusYears(1L);
        });
    }

    public static TemporalAdjuster previousDay() {
        return TemporalAdjusters.ofDateAdjuster(date -> date.minus(1L, ChronoUnit.DAYS));
    }

    public static TemporalAdjuster previousLeapYear() {
        return temporal -> {
            int year = temporal.get(ChronoField.YEAR) - 1;
            if (!Year.isLeap(year = (int)(Math.floor((double)year / 4.0) * 4.0))) {
                year -= 4;
            }
            return temporal.with(ChronoField.YEAR, year);
        };
    }

    public static TemporalAdjuster previousOrSame(MonthDay monthDay) {
        Contract.checkArgument(monthDay != null, "MonthDay must not be null", new Object[0]);
        return TemporalAdjusters.ofDateAdjuster(date -> {
            if (MonthDays.is(monthDay, Month.FEBRUARY, 29)) {
                LocalDate candidate = (date = date.with(MoreTemporalAdjusters.previousOrSameLeapYear())).with(monthDay);
                return candidate.isAfter((ChronoLocalDate)date) ? candidate.with(MoreTemporalAdjusters.previousLeapYear()) : candidate;
            }
            LocalDate candidate = date.with(monthDay);
            return candidate.isAfter((ChronoLocalDate)date) ? candidate.minusYears(1L) : candidate;
        });
    }

    public static TemporalAdjuster previousOrSameLeapYear() {
        return temporal -> {
            int year = temporal.get(ChronoField.YEAR);
            if (Year.isLeap(year)) {
                return temporal;
            }
            if (!Year.isLeap(year = (int)(Math.floor((double)year / 4.0) * 4.0))) {
                year -= 4;
            }
            return temporal.with(ChronoField.YEAR, year);
        };
    }

    public static TemporalAdjuster previousOrSameWorkingDay(GeoRegion region) {
        Contract.checkArgument(region != null, "Region must not be null", new Object[0]);
        return temporal -> {
            while (!Temporals.isWorkingDay(temporal, region)) {
                temporal = temporal.minus(1L, ChronoUnit.DAYS);
            }
            return temporal;
        };
    }

    public static TemporalAdjuster previousWorkingDay(GeoRegion region) {
        Contract.checkArgument(region != null, "Region must not be null", new Object[0]);
        return temporal -> {
            while (!Temporals.isWorkingDay(temporal = temporal.minus(1L, ChronoUnit.DAYS), region)) {
            }
            return temporal;
        };
    }

    public static TemporalAdjuster shroveMonday() {
        return temporal -> temporal.with(MoreTemporalAdjusters.easterSunday()).minus(48L, ChronoUnit.DAYS);
    }

    public static TemporalAdjuster shroveTuesday() {
        return temporal -> temporal.with(MoreTemporalAdjusters.easterSunday()).minus(47L, ChronoUnit.DAYS);
    }

    public static TemporalAdjuster storeBededag() {
        return temporal -> temporal.with(MoreTemporalAdjusters.easterSunday()).plus(26L, ChronoUnit.DAYS);
    }

    public static TemporalAdjuster trinitySunday() {
        return temporal -> temporal.with(MoreTemporalAdjusters.easterSunday()).plus(56L, ChronoUnit.DAYS);
    }

    public static TemporalAdjuster whitMonday() {
        return temporal -> temporal.with(MoreTemporalAdjusters.easterSunday()).plus(50L, ChronoUnit.DAYS);
    }

    public static TemporalAdjuster whitSunday() {
        return temporal -> temporal.with(MoreTemporalAdjusters.easterSunday()).plus(49L, ChronoUnit.DAYS);
    }

    private static MonthDay computeEasterSunday(int year) {
        int a = year % 19;
        int b = year / 100;
        int c = (b - b / 4 - (8 * b + 13) / 25 + 19 * a + 15) % 30;
        int d = c - c / 28 * (1 - 29 / (c + 1) * ((21 - a) / 11));
        int e = (year + year / 4 + d + 2 - b + b / 4) % 7;
        int f = d - e;
        int month = 3 + (f + 40) / 44;
        int day = f + 28 - 31 * (month / 4);
        return MonthDay.of(month, day);
    }

    private static MonthDay computeOrthodoxEasterSunday(int year) {
        int a = year % 19;
        int b = (19 * a + 15) % 30;
        int c = (year + year / 4 + b) % 7;
        int d = b - c;
        int month = 3 + (d + 40) / 44;
        int day = d + 28 - 31 * (month / 4);
        return MonthDay.from(CalendarConversionUtils.julianToGregorian(JulianLocalDate.of(year, month, day)));
    }
}

