/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.time;

import java.time.temporal.IsoFields;
import java.time.temporal.Temporal;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.sellcom.geotemporal.geography.GeoRegion;
import org.sellcom.geotemporal.internal.Contract;
import org.sellcom.geotemporal.internal.time.Holidays;
import org.sellcom.geotemporal.internal.time.Weekends;
import org.sellcom.geotemporal.internal.time.WorkingDays;
import org.sellcom.geotemporal.time.GeoTemporalPredicate;
import org.sellcom.geotemporal.time.HolidayPredicate;
import org.sellcom.geotemporal.time.HolidayType;

public class Temporals {
    private static final Map<String, HolidayPredicate> customHolidayPredicates = new HashMap<String, HolidayPredicate>();
    private static final Map<String, GeoTemporalPredicate> customWeekendPredicates = new HashMap<String, GeoTemporalPredicate>();
    private static final Map<String, GeoTemporalPredicate> customWorkingDayPredicates = new HashMap<String, GeoTemporalPredicate>();

    private Temporals() {
    }

    public static int getIsoWeekNumber(Temporal temporal) {
        Contract.checkArgument(temporal != null, "Temporal must not be null", new Object[0]);
        return temporal.get(IsoFields.WEEK_OF_WEEK_BASED_YEAR);
    }

    public static boolean isHoliday(Temporal temporal, GeoRegion region, EnumSet<HolidayType> types) {
        Contract.checkArgument(temporal != null, "Temporal must not be null", new Object[0]);
        Contract.checkArgument(region != null, "Region must not be null", new Object[0]);
        Contract.checkArgument(types != null, "Holiday types must not be null", new Object[0]);
        HolidayPredicate predicate = customHolidayPredicates.get(region.getCountryCode());
        if (predicate != null) {
            return predicate.test(temporal, region, types);
        }
        return Holidays.isHoliday(temporal, region, types);
    }

    public static boolean isPublicHoliday(Temporal temporal, GeoRegion region) {
        return Temporals.isHoliday(temporal, region, EnumSet.of(HolidayType.PUBLIC));
    }

    public static boolean isSchoolHoliday(Temporal temporal, GeoRegion region) {
        return Temporals.isHoliday(temporal, region, EnumSet.of(HolidayType.SCHOOLS_AND_UNIVERSITIES_ONLY, HolidayType.SCHOOLS_ONLY));
    }

    public static boolean isWeekend(Temporal temporal, GeoRegion region) {
        Contract.checkArgument(temporal != null, "Temporal must not be null", new Object[0]);
        Contract.checkArgument(region != null, "Region must not be null", new Object[0]);
        GeoTemporalPredicate predicate = customWeekendPredicates.get(region.getCountryCode());
        if (predicate != null) {
            return predicate.test(temporal, region);
        }
        return Weekends.isWeekend(temporal, region);
    }

    public static boolean isWorkingDay(Temporal temporal, GeoRegion region) {
        Contract.checkArgument(temporal != null, "Temporal must not be null", new Object[0]);
        Contract.checkArgument(region != null, "Region must not be null", new Object[0]);
        GeoTemporalPredicate predicate = customWorkingDayPredicates.get(region.getCountryCode());
        if (predicate != null) {
            return predicate.test(temporal, region);
        }
        Optional<Boolean> result = WorkingDays.isWorkingDay(temporal, region);
        if (result.isPresent()) {
            return result.get();
        }
        return !Temporals.isWeekend(temporal, region) && !Temporals.isPublicHoliday(temporal, region);
    }

    public static void registerCustomHolidayPredicate(String countryCode, HolidayPredicate predicate) {
        Contract.checkArgument(countryCode != null, "Country code must not be null", new Object[0]);
        Contract.checkArgument(predicate != null, "Holiday predicate must not be null", new Object[0]);
        customHolidayPredicates.put(countryCode, predicate);
    }

    public static void registerCustomWeekendPredicate(String countryCode, GeoTemporalPredicate predicate) {
        Contract.checkArgument(countryCode != null, "Country code must not be null", new Object[0]);
        Contract.checkArgument(predicate != null, "Weekend predicate must not be null", new Object[0]);
        customWeekendPredicates.put(countryCode, predicate);
    }

    public static void registerCustomWorkingDayPredicate(String countryCode, GeoTemporalPredicate predicate) {
        Contract.checkArgument(countryCode != null, "Country code must not be null", new Object[0]);
        Contract.checkArgument(predicate != null, "Working day predicate must not be null", new Object[0]);
        customWorkingDayPredicates.put(countryCode, predicate);
    }
}

